/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.buffer;

import fork.lib.math.algebra.elementary.set.continuous.Region;
import java.util.ArrayList;

public abstract class RegionBufferAbstract {
    protected ArrayList<Region> blist;
    public int keepLeft = 0;

    public RegionBufferAbstract() {
        this.init();
    }

    private void init() {
        this.blist = new ArrayList();
    }

    public ArrayList<Region> reloadAndGetList(Region r) throws Exception {
        this.appendRight(r);
        this.removeLeft(r);
        return this.blist;
    }

    protected void removeLeft(Region r) {
        Region lowr;
        while (!this.blist.isEmpty() && (lowr = this.blist.get(0)).lowerThan(r.low() - (double)this.keepLeft)) {
            this.blist.remove(0);
        }
    }

    protected void appendRight(Region r) throws Exception {
        Region nr;
        while ((nr = this.nextRegion()) != null) {
            if (nr.higherThan(r)) {
                this.doRegionHigherThanTarget();
                break;
            }
            if (this.keepLeft != 0) {
                if (!nr.overlapsWith(new Region(r.low() - (double)this.keepLeft, r.high()))) continue;
                this.blist.add(nr);
                continue;
            }
            if (!nr.overlapsWith(r)) continue;
            this.blist.add(nr);
        }
    }

    protected void doRegionHigherThanTarget() {
    }

    protected abstract Region nextRegion() throws Exception;
}

