/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.classifier.neural;

import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.algebra.elementary.function.v1.FunctionV1;
import fork.lib.math.applied.learning.classifier.neural.NeuronLayer;
import fork.lib.math.applied.learning.classifier.neural.NeuronNetwork;
import java.util.Arrays;
import java.util.List;

public class Neuron
extends Vector {
    protected FunctionV1 func = null;
    protected double bias = Double.NEGATIVE_INFINITY;
    protected double valBefore = 0.0;
    protected double val = 0.0;
    protected double deriv;

    public Neuron(List<Double> vs, Double bias, FunctionV1 func) throws Exception {
        super(vs);
        this.func = func;
        this.bias = bias;
        this.init();
    }

    public Neuron(Double ... vs) throws Exception {
        this(Arrays.asList(vs), (Double)0.0, null);
    }

    public Neuron(int n) throws Exception {
        this(Vector.sequence(0.0, 1.0, (Integer)n), (Double)0.0, null);
    }

    protected void init() throws Exception {
        if (this.bias == Double.NEGATIVE_INFINITY) {
            this.bias = 1.0;
        }
        if (this.func == null) {
            this.func = Neuron.defaultActivationFunction();
        }
    }

    public static FunctionV1 defaultActivationFunction() throws Exception {
        return new FunctionV1(){

            @Override
            public double getY(double x) {
                return 1.0 / (1.0 + Math.exp(-x));
            }
        };
    }

    public double evaluate(Vector vec) throws Exception {
        this.valBefore = this.innerProduct(vec) + this.bias;
        this.val = this.func.getY(this.valBefore);
        return this.val;
    }

    public double getInactivatedValue() {
        return this.valBefore;
    }

    public double getActivatedValue() {
        return this.val;
    }

    public double getDerivative() {
        return this.deriv;
    }

    public double computeDerivative(double tar) {
        this.deriv = (this.val - tar) * this.val * (1.0 - this.val);
        return this.deriv;
    }

    public double computeDerivative(NeuronLayer lay, int ind) {
        this.deriv = 0.0;
        for (Neuron n : lay) {
            this.deriv += (Double)n.get(ind) * n.getDerivative() * this.val * (1.0 - this.val);
        }
        return this.deriv;
    }

    public void updateWeights(Vector prev, double rate) {
        for (int i = 0; i < this.size(); ++i) {
            double ov = (Double)this.get(i);
            double nv = ov - rate * this.deriv * (Double)prev.get(i);
            this.set(i, nv);
        }
        this.bias -= rate * this.deriv;
    }

    public static void main(String[] args) throws Exception {
        NeuronNetwork.main(args);
    }
}

