/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.classifier.neural;

import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.applied.learning.classifier.neural.Neuron;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NeuronLayer
extends ArrayList<Neuron> {
    protected Vector deriv = new Vector();

    public NeuronLayer(List<Neuron> ns) throws Exception {
        this.addAll(ns);
    }

    public NeuronLayer(Neuron ... ns) throws Exception {
        this(Arrays.asList(ns));
    }

    public NeuronLayer(int vecDim, int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.add(new Neuron(vecDim));
        }
    }

    public Vector evaluate(Vector vec) throws Exception {
        Vector ret = new Vector();
        for (Neuron n : this) {
            ret.add(n.evaluate(vec));
        }
        return ret;
    }

    public Vector getActivatedValues() throws Exception {
        Vector ret = new Vector();
        for (Neuron n : this) {
            ret.add(n.getActivatedValue());
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        Neuron n11 = new Neuron(Arrays.asList(0.15, 0.2), (Double)0.35, null);
        Neuron n12 = new Neuron(Arrays.asList(0.25, 0.3), (Double)0.35, null);
        Neuron n21 = new Neuron(Arrays.asList(0.4, 0.45), (Double)0.6, null);
        Neuron n22 = new Neuron(Arrays.asList(0.5, 0.55), (Double)0.6, null);
        NeuronLayer l1 = new NeuronLayer(n11, n12);
        NeuronLayer l2 = new NeuronLayer(n21, n22);
        Vector vec = new Vector(0.05, 0.1);
        System.out.println(l2.evaluate(l1.evaluate(vec)));
    }
}

