/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.classifier.neural;

import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.applied.learning.classifier.neural.Neuron;
import fork.lib.math.applied.learning.classifier.neural.NeuronLayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NeuronNetwork
extends ArrayList<NeuronLayer> {
    protected Vector value = null;
    protected Vector err = null;
    protected Vector input = null;
    protected Vector target = null;
    protected double rate = 0.1;

    public NeuronNetwork(List<NeuronLayer> ls) throws Exception {
        this.addAll(ls);
    }

    public NeuronNetwork(NeuronLayer ... ls) throws Exception {
        this(Arrays.asList(ls));
    }

    public NeuronNetwork(int vecDim, List<Integer> neuns) throws Exception {
        int prevn = vecDim;
        for (int i = 0; i < neuns.size(); ++i) {
            int neun = neuns.get(i);
            this.add(new NeuronLayer(prevn, neun));
            prevn = neun;
        }
    }

    public Vector evaluate(Vector vec) throws Exception {
        this.input = vec;
        this.value = null;
        for (NeuronLayer nl : this) {
            if (this.value == null) {
                this.value = nl.evaluate(vec);
                continue;
            }
            this.value = nl.evaluate(this.value);
        }
        return this.value;
    }

    public Vector computeError(Vector tar) throws Exception {
        this.target = tar;
        this.err = new Vector();
        for (int i = 0; i < tar.size(); ++i) {
            this.err.add(0.5 * Math.pow((Double)this.value.get(i) - (Double)tar.get(i), 2.0));
        }
        return this.err;
    }

    public void setLearningRate(double rate) {
        this.rate = rate;
    }

    public void backTrack() throws Exception {
        int i;
        for (i = this.size() - 1; i >= 0; --i) {
            int j;
            NeuronLayer nl = (NeuronLayer)this.get(i);
            if (i == this.size() - 1) {
                for (j = 0; j < nl.size(); ++j) {
                    ((Neuron)nl.get(j)).computeDerivative((Double)this.target.get(j));
                }
                continue;
            }
            for (j = 0; j < nl.size(); ++j) {
                ((Neuron)nl.get(j)).computeDerivative((NeuronLayer)this.get(i + 1), j);
            }
        }
        for (i = 0; i < this.size(); ++i) {
            NeuronLayer lay = (NeuronLayer)this.get(i);
            Vector prev = i == 0 ? this.input : ((NeuronLayer)this.get(i - 1)).getActivatedValues();
            for (Neuron n : lay) {
                n.updateWeights(prev, this.rate);
            }
        }
    }

    public Vector getValue() {
        return this.value;
    }

    public double getError() {
        double ret = 0.0;
        for (int i = 0; i < this.err.size(); ++i) {
            ret += ((Double)this.err.get(i)).doubleValue();
        }
        return ret;
    }

    public Vector getInput() {
        return this.input;
    }

    public double getLearningRate() {
        return this.rate;
    }

    public void print() {
        System.out.println();
        for (int i = 0; i < this.size(); ++i) {
            NeuronLayer lay = (NeuronLayer)this.get(i);
            System.out.println("layer " + i + ":");
            for (int j = 0; j < lay.size(); ++j) {
                System.out.println("   " + lay.get(j) + "  " + ((Neuron)lay.get((int)j)).bias);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        int i;
        NeuronNetwork nw = new NeuronNetwork(2, Arrays.asList(3, 4, 1));
        nw.setLearningRate(5.0);
        for (int i2 = 0; i2 < nw.size(); ++i2) {
            NeuronLayer lay = (NeuronLayer)nw.get(i2);
            System.out.println("layer " + i2 + ":");
            for (int j = 0; j < lay.size(); ++j) {
                System.out.println("   " + lay.get(j));
            }
        }
        Vector[] vecs = new Vector[]{new Vector(0.0, 0.0), new Vector(0.0, 1.0), new Vector(1.0, 0.0), new Vector(1.0, 1.0)};
        Vector[] ress = new Vector[]{new Vector(0.0), new Vector(1.0), new Vector(1.0), new Vector(0.0)};
        for (i = 0; i < 10000; ++i) {
            for (int j = 0; j < vecs.length; ++j) {
                nw.evaluate(vecs[j]);
                nw.computeError(ress[j]);
                nw.backTrack();
            }
        }
        System.out.println();
        for (i = 0; i < nw.size(); ++i) {
            NeuronLayer lay = (NeuronLayer)nw.get(i);
            System.out.println("layer " + i + ":");
            for (int j = 0; j < lay.size(); ++j) {
                System.out.println("   " + lay.get(j) + "  " + ((Neuron)lay.get((int)j)).bias);
            }
        }
        System.out.println();
        for (i = 0; i < vecs.length; ++i) {
            System.out.println(vecs[i] + "   " + nw.evaluate(vecs[i]));
        }
    }
}

