/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.classifier.tree;

import fork.lib.base.collection.NamedTable;
import fork.lib.base.file.io.txt.ReadTable;
import fork.lib.base.format.collection.ArrayOp1D;
import fork.lib.base.format.collection.FormatOp1D;
import fork.lib.math.algebra.advanced.linearalgebra.Matrix;
import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.applied.learning.classifier.Classifier;
import fork.lib.math.applied.learning.classifier.tree.C45Classifier;
import fork.lib.math.applied.learning.classifier.tree.C45Condition;
import fork.lib.math.applied.learning.classifier.tree.NodeSplitCondition;
import fork.lib.math.applied.learning.classifier.tree.TreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class C45Node
extends TreeNode {
    public C45Node(Matrix mat, Vector outputs, HashSet<Integer> unusedinds) throws Exception {
        super(mat, outputs, unusedinds);
    }

    public C45Node(Matrix mat, Vector outputs) throws Exception {
        super(mat, outputs);
    }

    public C45Node() {
    }

    @Override
    protected ArrayList<ArrayList<NodeSplitCondition>> columnVectorToConditions(Vector vec) throws Exception {
        ArrayList<ArrayList<NodeSplitCondition>> ret;
        HashSet<Double> uniq = new HashSet<Double>();
        for (Double v : vec) {
            if (uniq.contains(v)) continue;
            uniq.add(v);
        }
        ArrayList<Double> uvs = new ArrayList<Double>();
        uvs.addAll(uniq);
        Collections.sort(uvs);
        if (uvs.size() <= 1) {
            ret = new ArrayList<ArrayList<NodeSplitCondition>>();
            ArrayList<C45Condition> conds = new ArrayList<C45Condition>();
            double v = (Double)uvs.get(0) * 0.99;
            conds.add(new C45Condition(new Region(Double.NEGATIVE_INFINITY, v)));
            conds.add(new C45Condition(new Region(v, Double.POSITIVE_INFINITY)));
            ret.add(conds);
            return ret;
        }
        ret = new ArrayList();
        for (int i = 0; i < uvs.size() - 1; ++i) {
            double va = (Double)uvs.get(i);
            double vb = (Double)uvs.get(i + 1);
            ArrayList<C45Condition> conds = new ArrayList<C45Condition>();
            conds.add(new C45Condition(new Region(Double.NEGATIVE_INFINITY, (va + vb) / 2.0)));
            conds.add(new C45Condition(new Region((va + vb) / 2.0, Double.POSITIVE_INFINITY)));
            ret.add(conds);
        }
        return ret;
    }

    @Override
    public C45Classifier getClassifier(ArrayList<String> head) throws Exception {
        return new C45Classifier(this, head);
    }

    @Override
    protected TreeNode childNode(Matrix mat, Vector outs, HashSet<Integer> ninds) throws Exception {
        return new C45Node(mat, outs, ninds);
    }

    public static void main(String[] args) throws Exception {
        ReadTable rt = new ReadTable("C:\\muxingu\\data\\own\\irina_ML\\anal/datf.txt");
        NamedTable<String, String, String> tab = rt.getTable().toNamedTable();
        ArrayList<Vector> vecs = new ArrayList<Vector>();
        for (int i = 0; i < tab.rowNumber(); ++i) {
            ArrayList<String> row = ArrayOp1D.subset(tab.getRow((String)i), 0, tab.getRow((String)i).size() - 1);
            vecs.add(new Vector((List<Double>)FormatOp1D.stringToDouble(row)));
        }
        Matrix mat = new Matrix((List<Vector>)vecs);
        ArrayList<String> head = tab.columnNames();
        Vector outs = new Vector((List<Double>)FormatOp1D.stringToDouble(tab.getColumn("suv")));
        C45Node dn = new C45Node(mat, outs);
        dn.computeChildren();
        Classifier cl = ((TreeNode)dn).getClassifier(head);
        System.out.println(cl);
    }
}

