/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.classifier.tree;

import fork.lib.math.applied.learning.classifier.tree.ID3Node;
import fork.lib.math.applied.learning.classifier.tree.TreeClassifier;
import fork.lib.math.applied.learning.classifier.tree.TreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ID3Classifier
extends TreeClassifier {
    public ID3Classifier(TreeNode root) throws Exception {
        super(root);
    }

    public ID3Classifier(TreeNode root, List<String> head) throws Exception {
        super(root, head);
    }

    public static ID3Classifier parseClassifier(String str, List<String> head) throws Exception {
        HashMap<String, Integer> headInd = new HashMap<String, Integer>();
        for (int i = 0; i < head.size(); ++i) {
            headInd.put(head.get(i), i);
        }
        ID3Node root = new ID3Node();
        ID3Classifier.parseNode(root, Arrays.asList(str.split("\n")), 0, headInd, null);
        return new ID3Classifier(root, head);
    }

    private static void parseNode(TreeNode dn, List<String> rows, int lvl, HashMap<String, Integer> headInd, TreeNode parent) throws Exception {
        int i;
        String splstr;
        if (rows.isEmpty() || rows.get(0).equals("")) {
            return;
        }
        String r0 = ID3Classifier.parseLine(rows.get(0), lvl);
        if (r0.contains(IS)) {
            String[] ss = r0.split(IS);
            dn.ifLeaf = true;
            dn.leafVal = Double.parseDouble(ss[1]);
            return;
        }
        if (parent == null) {
            splstr = r0;
        } else {
            String[] ss = r0.split(CONDITION);
            splstr = ss[1];
        }
        dn.ind = headInd.get(splstr);
        ArrayList splrows = new ArrayList();
        ArrayList<String> buff = new ArrayList<String>();
        for (i = 0; i < rows.size(); ++i) {
            String l = rows.get(i);
            int llv = ID3Classifier.lineLevel(l);
            if (llv <= lvl) continue;
            if (llv == lvl + 1 && !buff.isEmpty()) {
                splrows.add(buff);
                buff = new ArrayList();
            }
            buff.add(l);
        }
        if (!buff.isEmpty()) {
            splrows.add(buff);
        }
        for (i = 0; i < splrows.size(); ++i) {
            ID3Node ch = new ID3Node();
            ch.setParent(dn);
            dn.children.add(ch);
            ID3Classifier.parseNode(ch, (List)splrows.get(i), lvl + 1, headInd, dn);
        }
    }
}

