/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.classifier.tree;

import fork.lib.math.algebra.advanced.linearalgebra.Matrix;
import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.applied.learning.classifier.Classifier;
import fork.lib.math.applied.learning.classifier.tree.ID3Classifier;
import fork.lib.math.applied.learning.classifier.tree.ID3Condition;
import fork.lib.math.applied.learning.classifier.tree.NodeSplitCondition;
import fork.lib.math.applied.learning.classifier.tree.TreeNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class ID3Node
extends TreeNode {
    public ID3Node(Matrix mat, Vector outputs, HashSet<Integer> unusedinds) throws Exception {
        super(mat, outputs, unusedinds);
    }

    public ID3Node(Matrix mat, Vector outputs) throws Exception {
        super(mat, outputs);
    }

    public ID3Node() {
    }

    @Override
    protected ArrayList<ArrayList<NodeSplitCondition>> columnVectorToConditions(Vector vec) throws Exception {
        ArrayList<ID3Condition> conds = new ArrayList<ID3Condition>();
        HashSet<Double> uniq = new HashSet<Double>();
        for (Double v : vec) {
            if (uniq.contains(v)) continue;
            uniq.add(v);
        }
        for (Double v : uniq) {
            conds.add(new ID3Condition(v));
        }
        ArrayList<ArrayList<NodeSplitCondition>> ret = new ArrayList<ArrayList<NodeSplitCondition>>();
        ret.add(conds);
        return ret;
    }

    @Override
    protected TreeNode childNode(Matrix mat, Vector outs, HashSet<Integer> ninds) throws Exception {
        return new ID3Node(mat, outs, ninds);
    }

    @Override
    public ID3Classifier getClassifier(ArrayList<String> head) throws Exception {
        if (this.ind == -1) {
            this.computeChildren();
        }
        return new ID3Classifier(this, head);
    }

    public ID3Classifier getClassifier() throws Exception {
        return this.getClassifier((ArrayList)null);
    }

    public static void main(String[] args) throws Exception {
        String[] heads = new String[]{"a", "b", "c"};
        Matrix mat = new Matrix(new double[][]{{1.0, 0.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 0.0, 1.0}, {0.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {0.0, 1.0, 1.0}});
        ArrayList<String> head = new ArrayList<String>();
        head.addAll(Arrays.asList(heads));
        ID3Node dn = new ID3Node(mat, new Vector(1.0, 0.0, 2.0, 3.0, 2.0, 0.0));
        dn.computeChildren();
        Classifier cl = ((TreeNode)dn).getClassifier(head);
        System.out.println(cl);
    }
}

