/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.classifier.tree;

import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.applied.learning.classifier.tree.NodeSplitCondition;
import fork.lib.math.applied.stat.Distribution;
import fork.lib.math.applied.stat.FrequencyCount;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NodeSplit {
    protected Vector vec;
    protected Vector outs;
    protected HashMap<NodeSplitCondition, Double> condClas = new HashMap();
    protected Vector clas;
    protected HashMap<Double, NodeSplitCondition> clasCond = new HashMap();
    protected double entropy;
    protected double ig;
    protected HashMap<Double, Double> clasOut = new HashMap();
    protected HashMap<Double, Vector> clasVec = new HashMap();

    public NodeSplit(Vector vec, List<NodeSplitCondition> conds, Vector outs) throws Exception {
        this.vec = vec;
        this.outs = outs;
        for (int i = 0; i < conds.size(); ++i) {
            NodeSplitCondition c = conds.get(i);
            double v = i;
            this.condClas.put(c, v);
            this.clasCond.put(v, c);
        }
        this.init();
    }

    protected void init() throws Exception {
        this.entropy = NodeSplit.entropy(this.outs);
        this.clas = this.computeClasses();
        this.ig = this.informationGain(this.clas, this.outs);
    }

    protected Vector computeClasses() throws Exception {
        Vector ret = new Vector();
        for (Double v : this.vec) {
            double clas = -1.0;
            for (NodeSplitCondition cond : this.condClas.keySet()) {
                if (!cond.satisfy(v)) continue;
                clas = this.condClas.get(cond);
                break;
            }
            ret.add(clas);
        }
        return ret;
    }

    public Double informationGain() {
        return this.ig;
    }

    private double informationGain(Vector clas, Vector outs) {
        for (int i = 0; i < clas.size(); ++i) {
            Double v = (Double)clas.get(i);
            if (!this.clasVec.containsKey(v)) {
                this.clasVec.put(v, new Vector());
            }
            this.clasVec.get(v).add(outs.get(i));
        }
        double ret = this.entropy;
        for (Double v : this.clasVec.keySet()) {
            Vector vec = this.clasVec.get(v);
            ret -= NodeSplit.entropy(vec) * (double)vec.size() / (double)outs.size();
        }
        return ret;
    }

    public static double entropy(Vector vec) {
        FrequencyCount<Double> fc = new FrequencyCount<Double>();
        for (Double v : vec) {
            fc.add(v);
        }
        double ret = 0.0;
        for (Double v : fc.keys()) {
            int c = fc.getCount(v);
            ret += NodeSplit.entropyForOutput((double)c / (double)vec.size());
        }
        return ret;
    }

    public static double entropyForOutput(double frac) {
        if (frac == 0.0 || frac == 1.0) {
            return 0.0;
        }
        return frac * Math.log(1.0 / frac);
    }

    public HashMap<Double, ArrayList<Integer>> classSplitIndeces() throws Exception {
        HashMap<Double, ArrayList<Integer>> ret = new HashMap<Double, ArrayList<Integer>>();
        for (int i = 0; i < this.clas.size(); ++i) {
            double v = (Double)this.clas.get(i);
            if (!ret.containsKey(v)) {
                ret.put(v, new ArrayList());
            }
            ret.get(v).add(i);
        }
        return ret;
    }

    public double mostFrequentOutput() {
        double ret = -1.0;
        for (Double clas : this.clasVec.keySet()) {
            Vector vec = this.clasVec.get(clas);
            Distribution dis = vec.toDistribution();
            double fr = (Double)dis.mostFrequentKey();
            if (!(fr > ret)) continue;
            ret = fr;
        }
        return ret;
    }
}

