/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.classifier.tree;

import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.applied.learning.classifier.Classifier;
import fork.lib.math.applied.learning.classifier.tree.NodeSplitCondition;
import fork.lib.math.applied.learning.classifier.tree.TreeNode;
import java.util.ArrayList;
import java.util.List;

public class TreeClassifier
implements Classifier {
    public static String IS = " --> ";
    public static String CONDITION = " -- ";
    public static String TAB = "|  ";
    protected TreeNode root;
    protected ArrayList<String> head = new ArrayList();
    protected String str;

    public TreeClassifier(TreeNode root) throws Exception {
        this.root = root;
        this.init();
    }

    public TreeClassifier(TreeNode root, List<String> head) throws Exception {
        this.root = root;
        if (head != null) {
            this.head.addAll(head);
        }
        this.init();
    }

    protected void init() throws Exception {
        if (this.head == null || this.head.isEmpty()) {
            this.head = new ArrayList();
            for (int i = 0; i < this.root.mat.columnNumber(); ++i) {
                this.head.add(new Integer(i).toString());
            }
        }
        StringBuilder sb = new StringBuilder();
        this.appendString(sb, this.root, "", "");
        this.str = sb.toString();
    }

    private void appendString(StringBuilder sb, TreeNode dn, String tab, String cond) {
        if (dn.isLeaf()) {
            sb.append(tab + cond + IS + dn.leafVal + "\n");
            return;
        }
        String condsuf = dn.isRoot() ? "" : CONDITION;
        sb.append(tab + cond + condsuf + this.head.get(dn.ind) + "\n");
        for (int i = 0; i < dn.children.size(); ++i) {
            TreeNode ch = dn.children.get(i);
            String cond_ = ch.cond.toString();
            this.appendString(sb, ch, tab + TAB, cond_);
        }
    }

    @Override
    public String toString() {
        return this.str;
    }

    @Override
    public double evaluate(Vector vec) throws Exception {
        double ret = this.evaluateNode(this.root, vec);
        return ret;
    }

    private double evaluateNode(TreeNode n, Vector vec) throws Exception {
        if (n.isLeaf()) {
            return n.leafVal;
        }
        double val = vec.elementAt(n.ind);
        for (int i = 0; i < n.children.size(); ++i) {
            NodeSplitCondition nodecond = n.children.get((int)i).cond;
            if (!nodecond.satisfy(val)) continue;
            return this.evaluateNode(n.children.get(i), vec);
        }
        return Double.NaN;
    }

    public static String parseLine(String l, int lvl) {
        return l.substring(lvl * TAB.length());
    }

    public static int lineLevel(String l) {
        int ret = 0;
        while (l.indexOf(TAB) == 0) {
            ++ret;
            l = l.substring(TAB.length());
        }
        return ret;
    }
}

