/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.classifier.tree;

import fork.lib.math.algebra.advanced.linearalgebra.Matrix;
import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.applied.learning.classifier.Classifier;
import fork.lib.math.applied.learning.classifier.tree.NodeSplit;
import fork.lib.math.applied.learning.classifier.tree.NodeSplitCondition;
import fork.lib.math.applied.stat.Distribution;
import fork.lib.math.applied.stat.FrequencyCount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class TreeNode {
    protected Matrix mat;
    protected Vector outs;
    protected HashSet<Integer> unusedinds;
    protected TreeNode parent = null;
    protected ArrayList<TreeNode> children = new ArrayList();
    protected NodeSplitCondition cond;
    protected int ind = -1;
    protected boolean ifLeaf = false;
    protected double leafVal = Double.NEGATIVE_INFINITY;

    public TreeNode(Matrix mat, Vector outputs, HashSet<Integer> unusedinds) throws Exception {
        this.mat = mat.clone();
        this.outs = outputs.clone();
        this.unusedinds = unusedinds;
        this.init();
    }

    public TreeNode(Matrix mat, Vector outputs) throws Exception {
        this(mat, outputs, null);
    }

    public TreeNode() {
    }

    protected abstract ArrayList<ArrayList<NodeSplitCondition>> columnVectorToConditions(Vector var1) throws Exception;

    public abstract Classifier getClassifier(ArrayList<String> var1) throws Exception;

    protected abstract TreeNode childNode(Matrix var1, Vector var2, HashSet<Integer> var3) throws Exception;

    protected void init() throws Exception {
        int i;
        for (i = 0; i < this.mat.rowNumber(); ++i) {
            Distribution dis = ((Vector)this.mat.get(i)).toDistribution();
            if (dis.keySize() != 1) continue;
            this.mat.remove(i);
            this.outs.remove(i);
            --i;
        }
        if (this.unusedinds == null) {
            this.unusedinds = new HashSet();
            for (i = 0; i < this.mat.columnNumber(); ++i) {
                this.unusedinds.add(i);
            }
        }
    }

    public void computeChildren() throws Exception {
        if (this.mat.isEmpty()) {
            return;
        }
        if (this.unusedinds.isEmpty()) {
            this.ifLeaf = true;
            this.leafVal = this.computeLeaf();
            return;
        }
        if (this.isLeaf()) {
            return;
        }
        double maxig = Double.NEGATIVE_INFINITY;
        NodeSplit maxspl = null;
        for (int i = 0; i < this.mat.columnNumber(); ++i) {
            if (!this.unusedinds.contains(i)) continue;
            Vector colvec = this.mat.getColumn(i);
            ArrayList<ArrayList<NodeSplitCondition>> condss = this.columnVectorToConditions(colvec);
            Iterator<ArrayList<NodeSplitCondition>> iterator = condss.iterator();
            while (iterator.hasNext()) {
                ArrayList<NodeSplitCondition> conds = iterator.next();
                NodeSplit spl = new NodeSplit(colvec, conds, this.outs);
                double ig = spl.informationGain();
                if (!(ig > maxig)) continue;
                maxig = ig;
                this.ind = i;
                maxspl = spl;
            }
        }
        if (!this.isRoot() && maxig == 0.0) {
            this.ifLeaf = true;
            this.leafVal = maxspl.mostFrequentOutput();
            return;
        }
        HashMap<Double, ArrayList<Integer>> clasinds = maxspl.classSplitIndeces();
        ArrayList<Double> ks = new ArrayList<Double>();
        ks.addAll(clasinds.keySet());
        Collections.sort(ks);
        for (Double clasv : ks) {
            TreeNode ch = this.initChild(clasinds.get(clasv));
            ch.setCondition(maxspl.clasCond.get(clasv));
            this.children.add(ch);
        }
        HashSet<Double> os = this.outputSet();
        if (os.size() == 1) {
            this.ifLeaf = true;
            this.leafVal = os.iterator().next();
        }
    }

    public HashSet<Double> outputSet() {
        HashSet<Double> ret = new HashSet<Double>();
        this.appendOutputSet(ret);
        return ret;
    }

    protected void appendOutputSet(HashSet<Double> set) {
        if (this.isLeaf()) {
            set.add(this.leafVal);
            return;
        }
        for (TreeNode c : this.children) {
            c.appendOutputSet(set);
        }
    }

    public double entropy() {
        return NodeSplit.entropy(this.outs);
    }

    protected TreeNode initChild(ArrayList<Integer> cis) throws Exception {
        ArrayList<Vector> cms = new ArrayList<Vector>();
        ArrayList<Double> cos = new ArrayList<Double>();
        for (Integer ci : cis) {
            cms.add(this.mat.getRow(ci));
            cos.add((Double)this.outs.get(ci));
        }
        HashSet ninds = (HashSet)this.unusedinds.clone();
        ninds.remove(this.ind);
        Matrix mat_ = new Matrix((List<Vector>)cms);
        TreeNode dn = this.childNode(mat_, new Vector((List<Double>)cos), ninds);
        dn.parent = this;
        if (dn.entropy() == 0.0) {
            dn.ifLeaf = true;
            dn.leafVal = dn.computeLeaf();
        } else {
            dn.computeChildren();
        }
        return dn;
    }

    protected double computeLeaf() throws Exception {
        return new FrequencyCount<Double>(this.outs).mostFrequentKey();
    }

    public void setCondition(NodeSplitCondition cond) {
        this.cond = cond;
    }

    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    public boolean isLeaf() {
        return this.ifLeaf;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public double leafValue() {
        return this.leafVal;
    }
}

