/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.clust;

import fork.lib.math.applied.learning.clust.ClusteringParam;
import fork.lib.math.applied.learning.clust.DistanceMatrixException;
import fork.lib.math.applied.learning.clust.HierarchicalClusterEntry;
import fork.lib.math.applied.learning.clust.HierarchicalClustering;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class DistanceMatrix {
    protected ArrayList<HierarchicalClusterEntry> ens;
    protected HashMap<HierarchicalClusterEntry, HashMap<HierarchicalClusterEntry, Double>> dis;
    protected HashSet<HierarchicalClusterEntry> all;
    protected HashMap<Double, HashSet<HierarchicalClusterEntry>> minds;
    private ClusteringParam par;

    public DistanceMatrix(ArrayList<HierarchicalClusterEntry> ens, ClusteringParam par) throws Exception {
        this.ens = ens;
        this.par = par;
    }

    public void init() throws Exception {
        int i;
        this.minds = new HashMap(1);
        this.all = new HashSet();
        this.dis = new HashMap();
        double min = Double.MAX_VALUE;
        for (i = 0; i < this.ens.size() - 1; ++i) {
            HierarchicalClusterEntry e1 = this.ens.get(i);
            HashMap<HierarchicalClusterEntry, Double> vs = new HashMap<HierarchicalClusterEntry, Double>();
            for (int j = i + 1; j < this.ens.size(); ++j) {
                HierarchicalClusterEntry e2 = this.ens.get(j);
                double d = this.getDistance(e1, e2);
                if (d < min) {
                    this.setMinds(d, e1, e2);
                    min = d;
                }
                vs.put(e2, d);
            }
            this.dis.put(e1, vs);
        }
        for (i = 0; i < this.ens.size(); ++i) {
            this.all.add(this.ens.get(i));
        }
    }

    protected void setMinds(double d, HierarchicalClusterEntry e1, HierarchicalClusterEntry e2) {
        this.minds.clear();
        HashSet<HierarchicalClusterEntry> set = new HashSet<HierarchicalClusterEntry>();
        set.add(e1);
        set.add(e2);
        this.minds.put(d, set);
    }

    public void updateMinds() throws DistanceMatrixException {
        if (this.dis.keySet().size() < 2) {
            throw new DistanceMatrixException();
        }
        Iterator<HierarchicalClusterEntry> i1 = this.dis.keySet().iterator();
        double min = Double.MAX_VALUE;
        while (i1.hasNext()) {
            HierarchicalClusterEntry e1 = i1.next();
            HashMap<HierarchicalClusterEntry, Double> hm = this.dis.get(e1);
            for (HierarchicalClusterEntry e2 : hm.keySet()) {
                double v = hm.get(e2);
                if (!(v < min)) continue;
                this.setMinds(v, e1, e2);
                min = v;
            }
        }
    }

    public double getMinDistance() throws DistanceMatrixException {
        if (this.dis.isEmpty()) {
            throw new DistanceMatrixException();
        }
        if (this.minds.isEmpty()) {
            try {
                this.updateMinds();
                double ret = this.getMinDistance();
                return ret;
            }
            catch (DistanceMatrixException e) {
                return Double.MAX_VALUE;
            }
        }
        Double[] vs = new Double[this.minds.keySet().size()];
        this.minds.keySet().toArray(vs);
        if (vs.length != 1) {
            throw new DistanceMatrixException();
        }
        return vs[0];
    }

    public HierarchicalClusterEntry[] getMinDistanceEntries() throws DistanceMatrixException {
        HashSet<HierarchicalClusterEntry> h = this.getMinDistanceEntrySet();
        HierarchicalClusterEntry[] ret = new HierarchicalClusterEntry[h.size()];
        h.toArray(ret);
        return ret;
    }

    public HashSet<HierarchicalClusterEntry> getMinDistanceEntrySet() throws DistanceMatrixException {
        double v = this.getMinDistance();
        HashSet<HierarchicalClusterEntry> h = this.minds.get(v);
        return h;
    }

    public double getDistanceFor(HierarchicalClusterEntry e1, HierarchicalClusterEntry e2) throws DistanceMatrixException {
        if (this.dis.containsKey(e1)) {
            HashMap<HierarchicalClusterEntry, Double> h = this.dis.get(e1);
            if (h.containsKey(e2)) {
                return h.get(e2);
            }
            throw new DistanceMatrixException();
        }
        if (this.dis.containsKey(e2)) {
            HashMap<HierarchicalClusterEntry, Double> h = this.dis.get(e2);
            if (h.containsKey(e1)) {
                return h.get(e1);
            }
            throw new DistanceMatrixException();
        }
        throw new DistanceMatrixException();
    }

    protected double getDistance(HierarchicalClusterEntry en1, HierarchicalClusterEntry en2) throws Exception {
        return DistanceMatrix.getDistanceFromPar(en1, en2, this.par);
    }

    public static double getDistanceFromPar(HierarchicalClusterEntry en1, HierarchicalClusterEntry en2, ClusteringParam par) throws Exception {
        if (par.ifWeight) {
            return en1.weightedDistanceTo(en2, par.weight);
        }
        return en1.distanceTo(en2);
    }

    public static void main(String[] args) throws Exception {
        HierarchicalClustering.main(args);
    }
}

