/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.clust;

import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import java.util.HashSet;

public class HierarchicalClusterEntry<O> {
    protected Vector vec;
    protected O obj;
    protected HashSet<HierarchicalClusterEntry> children;

    public HierarchicalClusterEntry(O o) {
        this.obj = o;
        this.init();
    }

    public HierarchicalClusterEntry(Vector vec) {
        this.vec = vec;
        this.init();
    }

    public HierarchicalClusterEntry(Vector vec, O obj) {
        this(vec);
        this.obj = obj;
    }

    private void init() {
        this.children = new HashSet();
    }

    public void setVector(Vector v) {
        this.vec = v;
    }

    public double distanceTo(HierarchicalClusterEntry en) throws Exception {
        return this.distanceTo(en.getVector());
    }

    public double distanceTo(Vector v) throws Exception {
        return this.vec.distanceTo(v);
    }

    public double weightedDistanceTo(Vector v, Vector wei) throws Exception {
        return this.vec.weightedDistanceTo(v, wei);
    }

    public double weightedDistanceTo(HierarchicalClusterEntry en, Vector wei) throws Exception {
        return this.weightedDistanceTo(en.getVector(), wei);
    }

    public Vector getVector() {
        return this.vec;
    }

    public String getID() {
        if (this.obj == null) {
            return "";
        }
        return this.obj.toString();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void addChild(HierarchicalClusterEntry n) {
        this.children.add(n);
    }

    public HashSet<HierarchicalClusterEntry> getChildren() {
        return this.children;
    }
}

