/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.clust;

import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.applied.learning.clust.DistanceMatrixException;
import fork.lib.math.applied.learning.clust.HierarchicalClusterEntry;
import fork.lib.math.applied.learning.clust.HierarchicalDistanceMatrix;
import fork.lib.math.applied.learning.clust.HierarchicalException;
import fork.lib.math.applied.learning.clust.HierarchicalParam;
import fork.lib.math.applied.learning.clust.HierarchicalResult;
import java.util.ArrayList;

public class HierarchicalClustering {
    protected ArrayList<HierarchicalClusterEntry> data;
    public HierarchicalParam par;
    protected HierarchicalDistanceMatrix dis;
    protected HierarchicalResult res;

    public HierarchicalClustering(ArrayList<HierarchicalClusterEntry> data) throws Exception {
        this.data = data;
        this.init();
    }

    public HierarchicalClustering(ArrayList<HierarchicalClusterEntry> data, HierarchicalParam param) throws Exception {
        this(data);
        this.par = param;
    }

    private void init() throws Exception {
        if (this.par == null) {
            this.par = new HierarchicalParam();
        }
        this.dis = new HierarchicalDistanceMatrix(this.data, this.par);
        this.res = new HierarchicalResult(this.par);
    }

    public void start() throws Exception, DistanceMatrixException, HierarchicalException {
        this.dis.init();
        int no = 0;
        while (this.dis.all.size() >= 2) {
            HierarchicalClusterEntry[] es = this.dis.getMinDistanceEntries();
            HierarchicalClusterEntry<String> c = new HierarchicalClusterEntry<String>(es[0].getVector().add(es[1].getVector()).multiplyScalar(0.5), es[0].getID() + "_" + es[1].getID());
            for (int i = 0; i < es.length; ++i) {
                c.addChild(es[i]);
            }
            if (this.par.cpar.ifVerbose) {
                System.out.println("# " + no);
            }
            this.addToTree(es, c);
            if (this.dis.all.size() <= 2) {
                this.res.tree.setVector(c.getVector());
                break;
            }
            this.dis.updateHierarchy(es[0], es[1], c);
            ++no;
        }
    }

    protected void addToTree(HierarchicalClusterEntry[] ns, HierarchicalClusterEntry nave) {
        for (int i = 0; i < ns.length; ++i) {
            if (!this.res.tree.getChildren().contains(ns[i])) continue;
            this.res.tree.getChildren().remove(ns[i]);
        }
        this.res.tree.addChild(nave);
    }

    public HierarchicalResult getResult() {
        return this.res;
    }

    public static void main(String[] args) throws Exception {
        double[][] vss = new double[][]{{1.0, 0.0, 0.0}, {0.0, 10.0, 1.0}, {50.0, 9.0, 9.0}, {50.0, 20.0, 10.0}, {150.0, 10.0, 9.0}};
        Vector wei = new Vector(0.0, 1.0, 1.0);
        ArrayList<HierarchicalClusterEntry> al = new ArrayList<HierarchicalClusterEntry>();
        for (int i = 0; i < vss.length; ++i) {
            HierarchicalClusterEntry<String> en = new HierarchicalClusterEntry<String>(new Vector(vss[i]), Integer.toString(i + 1));
            al.add(en);
        }
        HierarchicalClustering cl = new HierarchicalClustering(al);
        cl.par.cpar.ifVerbose = true;
        cl.par.cpar.ifWeight = true;
        cl.par.cpar.weight = wei;
        cl.start();
        System.out.println(cl.getResult().toNewick());
    }
}

