/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.clust;

import fork.lib.math.applied.learning.clust.DistanceMatrix;
import fork.lib.math.applied.learning.clust.DistanceMatrixException;
import fork.lib.math.applied.learning.clust.HierarchicalClusterEntry;
import fork.lib.math.applied.learning.clust.HierarchicalException;
import fork.lib.math.applied.learning.clust.HierarchicalParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class HierarchicalDistanceMatrix
extends DistanceMatrix {
    protected HierarchicalParam par;

    public HierarchicalDistanceMatrix(ArrayList<HierarchicalClusterEntry> ens, HierarchicalParam par) throws Exception {
        super(ens, par.cpar);
        this.par = par;
    }

    public void updateHierarchy(HierarchicalClusterEntry e1, HierarchicalClusterEntry e2, HierarchicalClusterEntry c) throws HierarchicalException, Exception, DistanceMatrixException {
        double min;
        if (!this.all.contains(e1) || !this.all.contains(e2)) {
            throw new HierarchicalException();
        }
        HierarchicalClusterEntry[] es = new HierarchicalClusterEntry[]{e1, e2};
        for (int i = 0; i < es.length; ++i) {
            this.all.remove(es[i]);
        }
        HierarchicalClusterEntry[] en1s = new HierarchicalClusterEntry[this.dis.keySet().size()];
        this.dis.keySet().toArray(en1s);
        for (int i = 0; i < en1s.length; ++i) {
            HierarchicalClusterEntry en1 = en1s[i];
            if (en1.equals(e1) || en1.equals(e2)) {
                this.dis.remove(en1);
                if (this.minds.isEmpty() || !this.getMinDistanceEntrySet().contains(en1)) continue;
                this.minds.clear();
                continue;
            }
            HashMap hm2 = (HashMap)this.dis.get(en1);
            for (int j = 0; j < es.length; ++j) {
                HashSet mvalset;
                HierarchicalClusterEntry en2 = es[j];
                if (!hm2.containsKey(en2)) continue;
                if (!this.minds.isEmpty() && (mvalset = (HashSet)this.minds.get(this.getMinDistance())).contains(en1) && mvalset.contains(en2)) {
                    this.minds.clear();
                }
                hm2.remove(en2);
            }
        }
        try {
            min = this.getMinDistance();
        }
        catch (DistanceMatrixException dme) {
            min = Double.MAX_VALUE;
        }
        HashMap<HierarchicalClusterEntry, Double> h = new HashMap<HierarchicalClusterEntry, Double>();
        for (HierarchicalClusterEntry e : this.all) {
            double d = this.getDistance(e, c);
            if (d < min) {
                this.setMinds(d, e, c);
                min = d;
            }
            h.put(e, d);
        }
        this.dis.put(c, h);
        this.all.add(c);
    }
}

