/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.clust;

import fork.lib.math.applied.learning.clust.DistanceMatrix;
import fork.lib.math.applied.learning.clust.HierarchicalClusterEntry;
import fork.lib.math.applied.learning.clust.HierarchicalClustering;
import fork.lib.math.applied.learning.clust.HierarchicalParam;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.HashSet;
import java.util.Iterator;

public class HierarchicalResult {
    public HierarchicalClusterEntry tree = new HierarchicalClusterEntry<String>("root");
    public HierarchicalParam par;

    public HierarchicalResult(HierarchicalParam par) {
        this.par = par;
    }

    public String toNewickWithDistance() throws Exception {
        StringBuilder sb = new StringBuilder();
        this.appendNewickDist(sb, this.tree, null);
        return sb.toString();
    }

    protected void appendNewickDist(StringBuilder sb, HierarchicalClusterEntry n, HierarchicalClusterEntry parent) throws Exception {
        if (!n.hasChildren()) {
            sb.append(n.getID());
        } else {
            sb.append('(');
            HashSet<HierarchicalClusterEntry> set = n.getChildren();
            Iterator<HierarchicalClusterEntry> it = set.iterator();
            while (it.hasNext()) {
                this.appendNewickDist(sb, it.next(), n);
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(')');
        }
        if (parent != null) {
            double dis = DistanceMatrix.getDistanceFromPar(n, parent, this.par.cpar);
            BigDecimal bd = new BigDecimal(dis);
            String str = bd.round(new MathContext(3)).toString();
            sb.append(":");
            sb.append(str);
        }
    }

    public String toNewick() throws Exception {
        StringBuilder sb = new StringBuilder();
        this.appendNewick(sb, this.tree);
        return sb.toString();
    }

    protected void appendNewick(StringBuilder sb, HierarchicalClusterEntry n) throws Exception {
        if (!n.hasChildren()) {
            sb.append(n.getID());
        } else {
            sb.append('(');
            HashSet<HierarchicalClusterEntry> set = n.getChildren();
            Iterator<HierarchicalClusterEntry> it = set.iterator();
            while (it.hasNext()) {
                this.appendNewick(sb, it.next());
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(')');
        }
    }

    public static void main(String[] args) throws Exception {
        HierarchicalClustering.main(args);
        double v = 4543.1235;
    }
}

