/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.clust;

import fork.lib.base.collection.Table;
import fork.lib.base.file.io.txt.ReadTable;
import fork.lib.math.algebra.advanced.linearalgebra.Matrix;
import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.applied.learning.clust.KMeansClusteringParam;
import java.io.File;
import java.util.ArrayList;

public class KMeansClustering {
    protected Matrix mat;
    protected int nclus;
    protected KMeansClusteringParam par;
    protected ArrayList<ArrayList<Vector>> clusts = new ArrayList();
    protected Vector clusinds;
    protected int cyclen = 1;

    public KMeansClustering(Matrix mat, int nclus) {
        this.mat = mat;
        this.nclus = nclus;
        this.init();
    }

    protected void init() {
        if (this.par == null) {
            this.par = new KMeansClusteringParam();
        }
        this.clusinds = Vector.zeroVector(this.mat.size());
    }

    public KMeansClusteringParam param() {
        return this.par;
    }

    public void start() throws Exception {
        if (this.clusts.isEmpty()) {
            this.clusts = this.initClusts();
        }
        int n = 1;
        while (this.cycle() && ++n <= this.par.maxcycn) {
        }
    }

    protected boolean cycle() throws Exception {
        System.out.println("KMeans cycle: " + this.cyclen);
        ArrayList newclusts = new ArrayList();
        for (int i = 0; i < this.clusts.size(); ++i) {
            newclusts.add(new ArrayList());
        }
        ArrayList<Vector> aves = new ArrayList<Vector>();
        ArrayList<Boolean> ifvalid = new ArrayList<Boolean>();
        for (ArrayList<Vector> arr : this.clusts) {
            if (arr.isEmpty()) {
                aves.add(new Vector());
                ifvalid.add(false);
                continue;
            }
            aves.add(KMeansClustering.average(arr));
            ifvalid.add(true);
        }
        Vector newclusinds = new Vector();
        for (int i = 0; i < this.mat.size(); ++i) {
            Vector vec = (Vector)this.mat.get(i);
            double mindis = Double.MAX_VALUE;
            int minclusind = -1;
            for (int j = 0; j < aves.size(); ++j) {
                Vector ave;
                double dis;
                if (!((Boolean)ifvalid.get(j)).booleanValue() || !((dis = vec.distanceTo(ave = (Vector)aves.get(j))) < mindis)) continue;
                mindis = dis;
                minclusind = j;
            }
            newclusinds.add(Double.valueOf(minclusind));
            ((ArrayList)newclusts.get(minclusind)).add(vec);
        }
        boolean ret = !this.clusinds.equals(newclusinds);
        this.clusinds = newclusinds;
        this.clusts = newclusts;
        ++this.cyclen;
        return ret;
    }

    protected ArrayList<ArrayList<Vector>> initClusts() throws Exception {
        ArrayList<ArrayList<Vector>> ret = new ArrayList<ArrayList<Vector>>();
        int iind = (int)Math.floor(Math.random() * (double)this.mat.size());
        ArrayList arr = new ArrayList();
        arr.add(this.mat.get(iind));
        ret.add(arr);
        while (ret.size() < this.nclus) {
            double maxdis = 0.0;
            Vector maxvec = null;
            for (Vector vec : this.mat) {
                double dis = 0.0;
                for (ArrayList<Vector> ars : ret) {
                    dis += ars.get(0).distanceTo(vec);
                }
                if (!(dis > maxdis)) continue;
                maxdis = dis;
                maxvec = vec;
            }
            ArrayList<Vector> arr2 = new ArrayList<Vector>();
            arr2.add(maxvec);
            ret.add(arr2);
        }
        return ret;
    }

    public static Vector average(ArrayList<Vector> vecs) throws Exception {
        Vector ret = null;
        for (Vector v : vecs) {
            if (ret == null) {
                ret = v;
                continue;
            }
            ret = ret.add(v);
        }
        ret = ret.multiplyScalar(1.0 / (double)vecs.size());
        return ret;
    }

    public ArrayList<ArrayList<Vector>> getClusters() {
        return this.clusts;
    }

    public Vector getClusterIndexes() {
        return this.clusinds;
    }

    public static void main(String[] args) throws Exception {
        File d = new File("G:/test");
        Table<String> tab = new ReadTable(new File(d + "/xy.txt")).getTable();
        Matrix mat = new Matrix();
        for (int i = 0; i < tab.rowNumber(); ++i) {
            ArrayList<String> row = tab.getRow(i);
            mat.add(new Vector(Double.parseDouble(row.get(0)), Double.parseDouble(row.get(1))));
        }
        KMeansClustering kk = new KMeansClustering(mat, 4);
        kk.start();
    }
}

