/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.peak;

import fork.lib.math.algebra.elementary.function.v1.distr.DistributionFunction;
import fork.lib.math.algebra.elementary.function.v1.distr.NormalDistribution;
import fork.lib.math.algebra.elementary.function.v1.distr.NormalDistributionParam;
import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.analgeo.euclidean.d2.Landscape2D;
import fork.lib.math.applied.learning.peak.EMPeakDetectorParam;
import fork.lib.math.applied.optim.em.EM;
import fork.lib.math.applied.optim.em.EMResultEntry;
import fork.lib.math.applied.stat.Distribution;
import java.util.ArrayList;
import java.util.Collection;

public class EMPeakDetector {
    public Landscape2D data;
    protected EMPeakDetectorParam par;
    public double thr;
    public ArrayList<EMPeakDetector> subs;
    public EMPeakDetector parent;

    public EMPeakDetector(Landscape2D data, EMPeakDetectorParam par) throws Exception {
        this.data = data;
        this.par = par;
        this.init();
    }

    private void init() {
        if (this.par == null) {
            this.par = new EMPeakDetectorParam();
        }
    }

    public void start() throws Exception {
        this.thr = this.threshold();
        if (this.thr < this.par.stopThr) {
            this.subs = this.getNextLevel();
        }
    }

    protected double threshold() throws Exception {
        Distribution d = new Distribution((Collection<Double>)this.data.getValues());
        DistributionFunction[] fn = new DistributionFunction[]{new NormalDistribution(0.0, 1.0), new NormalDistribution(0.0, 1.0)};
        EM em = new EM(d, fn, null);
        EMResultEntry res = em.getOptimalResultEntry();
        double mm = Double.POSITIVE_INFINITY;
        double ms = Double.POSITIVE_INFINITY;
        if (res != null) {
            ArrayList<DistributionFunction> distrs = res.distrs;
            for (int i = 0; i < distrs.size(); ++i) {
                DistributionFunction df = distrs.get(i);
                NormalDistributionParam param = (NormalDistributionParam)df.param();
                if (!(param.mu < mm)) continue;
                mm = param.mu;
                ms = param.sigma;
            }
            double ret = mm + ms * 2.0;
            return ret;
        }
        return this.par.stopThr;
    }

    public ArrayList<EMPeakDetector> getNextLevel() throws Exception {
        ArrayList<EMPeakDetector> ret = new ArrayList<EMPeakDetector>();
        ArrayList<Landscape2D> subdata = this.data.applyThreshold(this.thr);
        for (int i = 0; i < subdata.size(); ++i) {
            Landscape2D sub = subdata.get(i);
            if (!this.par.satisfyMin(sub)) continue;
            EMPeakDetector npd = new EMPeakDetector(sub, this.par);
            npd.parent = this;
            if (this.par.startRecursive) {
                npd.start();
            }
            ret.add(npd);
        }
        return ret;
    }

    public void printAll() {
        this.printAll(this, "");
    }

    protected void printAll(EMPeakDetector p, String tag) {
        Region reg = p.data.getXRange();
        ArrayList<EMPeakDetector> spds = p.subs;
        double sthr = p.thr;
        int l = (int)reg.low();
        int h = (int)reg.high();
        System.out.println(tag + " " + l + " - " + h + "  thr: " + sthr);
        tag = tag + "   ";
        if (spds != null) {
            for (int i = 0; i < spds.size(); ++i) {
                this.printAll(spds.get(i), tag);
            }
        }
    }

    public void printLeaf(String tag) {
        this.printLeaf(tag, this);
    }

    protected void printLeaf(String t, EMPeakDetector p) {
        Region reg = p.data.getXRange();
        ArrayList<EMPeakDetector> spds = p.subs;
        int l = (int)reg.low();
        int h = (int)reg.high();
        if (spds != null && spds.size() > 0) {
            for (int i = 0; i < spds.size(); ++i) {
                this.printLeaf(t, spds.get(i));
            }
            if (this.par.satisfyMax(p.data)) {
                System.out.println(t + "\t" + l + "\t" + h);
            }
        } else {
            System.out.println(t + "\t" + l + "\t" + h);
        }
    }
}

