/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.peak;

import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.analgeo.euclidean.d2.Landscape2D;
import fork.lib.math.applied.learning.peak.HeightPeakDetectorParam;
import fork.lib.math.applied.stat.Distribution;
import java.util.ArrayList;
import java.util.Collection;

public class HeightPeakDetector {
    public Landscape2D data;
    public HeightPeakDetectorParam par;
    protected Peak root;

    public HeightPeakDetector(Landscape2D data, HeightPeakDetectorParam par) throws Exception {
        this.data = data;
        this.par = par;
        this.init();
    }

    protected void init() throws Exception {
        int i;
        if (this.par == null) {
            this.par = new HeightPeakDetectorParam();
        }
        this.root = new Peak(this.data);
        ArrayList<Landscape2D> breaks = this.data.applyThreshold(this.par.baseThr);
        for (i = 0; i < breaks.size(); ++i) {
            this.root.children.add(new Peak(breaks.get(i)));
        }
        for (i = 0; i < this.root.children.size(); ++i) {
            this.root.children.get(i).applyPeak(this.par.baseThr);
        }
    }

    public static ArrayList<Double> getThresholdLevels(Landscape2D data, double bthr, int n) {
        Distribution dis = new Distribution((Collection<Double>)data.getValues());
        double max = dis.max();
        double range = max - bthr;
        if (range <= 0.0) {
            return null;
        }
        double v = bthr;
        double step = range / (double)n * 2.0 / 3.0;
        ArrayList<Double> ret = new ArrayList<Double>();
        for (int i = 1; i <= n; ++i) {
            ret.add(v + step * (double)i);
        }
        return ret;
    }

    public ArrayList<Region> getAllPeaks() {
        ArrayList<Region> ret = new ArrayList<Region>();
        this.appendPeak(ret, this.root);
        return ret;
    }

    protected void appendPeak(ArrayList<Region> peaks, Peak p) {
        if (p.isLeaf()) {
            peaks.add(p.getHighestPar().toreg());
            return;
        }
        for (int i = 0; i < p.children.size(); ++i) {
            this.appendPeak(peaks, p.children.get(i));
        }
    }

    protected void joinPeaks() throws Exception {
        boolean ind = false;
    }

    class Peak {
        public Landscape2D ls;
        public Peak parent = null;
        public ArrayList<Peak> children = new ArrayList();

        public Peak(Landscape2D peak) {
            this.ls = peak;
        }

        public void applyPeak(double bthr) throws Exception {
            ArrayList<Double> thrs = HeightPeakDetector.getThresholdLevels(this.ls, bthr, HeightPeakDetector.this.par.nheight);
            for (int i = 0; i < thrs.size(); ++i) {
                double thr = thrs.get(i);
                ArrayList<Landscape2D> nlss = this.ls.applyThreshold(thr);
                if (nlss.size() <= 1) continue;
                for (int j = 0; j < nlss.size(); ++j) {
                    Peak np = new Peak(nlss.get(j));
                    if (!(np.ls.getXRange().getRange() > HeightPeakDetector.this.par.minWidth)) continue;
                    this.children.add(np);
                    np.parent = this;
                    np.applyPeak(thr);
                }
                break;
            }
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public Peak getHighestPar() {
            Peak ret = this;
            while (ret.parent != null && ret.parent.children.size() == 1) {
                ret = ret.parent;
            }
            return ret;
        }

        public Region toreg() {
            return this.ls.getXRange();
        }

        public void print() {
            this.printChildren("", this);
        }

        protected void printChildren(String tab, Peak p) {
            System.out.println(tab + p.ls.getXRange());
            if (this.isLeaf()) {
                return;
            }
            for (int i = 0; i < p.children.size(); ++i) {
                this.printChildren(tab + "|  ", p.children.get(i));
            }
        }
    }
}

