/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.learning.peak;

import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.analgeo.euclidean.d2.Landscape2D;
import fork.lib.math.applied.learning.peak.EMPeakDetector;
import fork.lib.math.applied.learning.peak.EMPeakDetectorParam;
import fork.lib.math.applied.learning.peak.HeightPeakDetector;
import fork.lib.math.applied.learning.peak.HeightPeakDetectorParam;
import fork.lib.math.applied.learning.peak.PeakDetectorParam;
import java.util.ArrayList;

public class PeakDetector {
    public Landscape2D data;
    public PeakDetectorParam par;
    public EMPeakDetectorParam emPar;
    public HeightPeakDetectorParam hPar;
    public ArrayList<Region> regs;

    public PeakDetector(Landscape2D data, PeakDetectorParam par, EMPeakDetectorParam emPar, HeightPeakDetectorParam hPar) throws Exception {
        this.data = data;
        this.par = par;
        this.emPar = emPar;
        this.hPar = hPar;
        this.init();
    }

    private void init() throws Exception {
        if (this.par == null) {
            this.par = new PeakDetectorParam();
        }
        if (this.emPar == null) {
            this.emPar = new EMPeakDetectorParam();
        }
        if (this.hPar == null) {
            this.hPar = new HeightPeakDetectorParam();
        }
        this.regs = new ArrayList();
        this.start();
    }

    protected void start() throws Exception {
        EMPeakDetector emp = new EMPeakDetector(this.data, this.emPar);
        emp.start();
        ArrayList<EMPeakDetector> pds = emp.subs;
        for (int i = 0; i < pds.size(); ++i) {
            Landscape2D dat = pds.get((int)i).data;
            this.hPar.baseThr = emp.thr;
            HeightPeakDetector hpd = new HeightPeakDetector(dat, this.hPar);
            ArrayList<Region> rs = hpd.getAllPeaks();
            if (!rs.isEmpty()) {
                this.regs.addAll(rs);
                continue;
            }
            if (!this.emPar.satisfyMin(dat) || !this.emPar.satisfyMax(dat)) continue;
            this.regs.add(dat.getXRange());
        }
        this.join(this.regs);
    }

    protected void join(ArrayList<Region> rs) {
        for (int i = 0; i < rs.size() - 1; ++i) {
            double dis;
            Region r = rs.get(i);
            Region rn = rs.get(i + 1);
            if (!rn.higherThan(r) || !((dis = rn.low() - r.high()) <= this.par.joinGap)) continue;
            try {
                Region ovl = new Region(r.low(), rn.high());
                rs.set(i, ovl);
                rs.remove(rn);
                --i;
                continue;
            }
            catch (Exception re) {
                re.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

