/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.optim.em;

import fork.lib.math.algebra.elementary.function.v1.FunctionV1;
import fork.lib.math.algebra.elementary.function.v1.distr.DistributionException;
import fork.lib.math.algebra.elementary.function.v1.distr.DistributionFunction;
import fork.lib.math.algebra.elementary.function.v1.distr.NormalDistribution;
import fork.lib.math.algebra.elementary.function.v1.distr.ParameterEstimation;
import fork.lib.math.algebra.elementary.function.v1.polynomial.ConstantFunction;
import fork.lib.math.applied.optim.em.EMCycle;
import fork.lib.math.applied.optim.em.EMException;
import fork.lib.math.applied.optim.em.EMParam;
import fork.lib.math.applied.optim.em.EMResultEntry;
import fork.lib.math.applied.stat.Distribution;
import java.util.ArrayList;

public class EM {
    protected Distribution data;
    protected DistributionFunction[] types;
    public EMParam par;
    public ArrayList<EMResultEntry> res;

    public EM(Distribution data, DistributionFunction[] types, EMParam par) throws Exception {
        this.data = data;
        this.types = types;
        this.par = par;
        this.init();
    }

    private void init() throws Exception {
        if (this.par == null) {
            this.par = new EMParam();
        }
        this.res = new ArrayList();
        if (this.par.autoStart) {
            this.start();
        }
    }

    public void start() throws Exception {
        double bicPrev = Double.POSITIVE_INFINITY;
        int cycle = 0;
        while (true) {
            ArrayList<DistributionFunction> distrs = cycle == 0 ? this.findStartDistrs() : this.res.get((int)(this.res.size() - 1)).distrs;
            ArrayList<Double> coeffs = cycle == 0 ? this.findStartCoeffs() : this.res.get((int)(this.res.size() - 1)).coeffs;
            EMCycle cyc = new EMCycle(this.data, distrs, coeffs);
            double bic = EM.bic(this.data, cyc.parEstim.funcsOut, cyc.parEstim.coeffsOut);
            this.res.add(new EMResultEntry(cyc.parEstim.coeffsOut, cyc.parEstim.funcsOut, bic));
            if (cycle >= this.par.maxCycle || Math.abs(bic - bicPrev) < this.par.llhThr) break;
            bicPrev = bic;
            ++cycle;
        }
    }

    protected ArrayList<DistributionFunction> findStartDistrs() throws EMException, DistributionException {
        ArrayList<DistributionFunction> ret = new ArrayList<DistributionFunction>();
        ArrayList<Distribution> subs = this.data.quantileSubsets(this.types.length);
        for (int i = 0; i < this.types.length; ++i) {
            if (!(this.types[i] instanceof NormalDistribution)) {
                if (this.types[i] instanceof NormalDistribution) {
                    throw new EMException();
                }
                throw new EMException();
            }
            ParameterEstimation pe = new ParameterEstimation(subs.get(i), new NormalDistribution(0.0, 1.0));
            ret.add(pe.funcOut);
        }
        return ret;
    }

    protected ArrayList<Double> findStartCoeffs() throws EMException {
        ArrayList<Double> ret = new ArrayList<Double>();
        for (int i = 0; i < this.types.length; ++i) {
            ret.add(1.0 / (double)this.types.length);
        }
        return ret;
    }

    public static double logLikelihood(Distribution data, ArrayList<DistributionFunction> distrs, ArrayList<Double> coeffs) throws Exception {
        FunctionV1 fn = new ConstantFunction(0.0);
        for (int i = 0; i < distrs.size(); ++i) {
            fn = fn.add(distrs.get(i).multiply(new ConstantFunction((double)coeffs.get(i))));
        }
        return data.logLikelihood(fn);
    }

    public static double bic(Distribution data, ArrayList<DistributionFunction> distrs, ArrayList<Double> coeffs) throws Exception {
        double llh = EM.logLikelihood(data, distrs, coeffs);
        int npar = 0;
        for (int i = 0; i < distrs.size(); ++i) {
            npar += distrs.get((int)i).par.npar + 1;
        }
        return -2.0 * llh;
    }

    public EMResultEntry getOptimalResultEntry() {
        EMResultEntry ret = null;
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.res.size(); ++i) {
            EMResultEntry r = this.res.get(i);
            if (!(r.bic < min)) continue;
            min = r.bic;
            ret = r;
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        Distribution d = new Distribution();
        d.add(0.0, 8.0);
        d.add(1.0, 10.0);
        d.add(2.0, 15.0);
        d.add(7.0, 5.0);
        d.add(8.0, 8.0);
        d.add(9.0, 10.0);
        d.add(10.0, 5.0);
        d.add(20.0, 5.0);
        d.add(21.0, 10.0);
        d.add(22.0, 8.0);
        d.add(120.0, 5.0);
        d.add(121.0, 10.0);
        d.add(122.0, 8.0);
        DistributionFunction[] types = new DistributionFunction[]{new NormalDistribution(0.0, 1.0), new NormalDistribution(0.0, 1.0), new NormalDistribution(0.0, 1.0), new NormalDistribution(0.0, 1.0)};
        EM em = new EM(d, types, null);
        em.start();
        EMResultEntry res = em.getOptimalResultEntry();
        ArrayList<Double> cs = res.coeffs;
        ArrayList<DistributionFunction> fn = res.distrs;
        for (int i = 0; i < cs.size(); ++i) {
            System.out.println("## " + cs.get(i));
            fn.get(i).printParametersAfter("  ");
        }
        System.out.println(res.bic);
    }
}

