/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.optim.em;

import fork.lib.math.algebra.elementary.function.v1.distr.DistributionException;
import fork.lib.math.algebra.elementary.function.v1.distr.DistributionFunction;
import fork.lib.math.algebra.elementary.function.v1.distr.ParameterEstimation;
import fork.lib.math.applied.stat.Distribution;
import java.util.ArrayList;

public class EMCycle {
    protected Distribution data;
    protected ArrayList<DistributionFunction> funcs;
    protected ArrayList<Double> coeffs;
    public EMParameterEstimation parEstim;

    public EMCycle(Distribution data, ArrayList<DistributionFunction> funcs, ArrayList<Double> coeffs) throws DistributionException {
        this.data = data;
        this.funcs = funcs;
        this.coeffs = coeffs;
        this.init();
    }

    private void init() throws DistributionException {
        this.parEstim = new EMParameterEstimation(EMCycle.cluster(this.data, this.funcs, this.coeffs), this.funcs);
    }

    public static ArrayList<Distribution> cluster(Distribution data, ArrayList<DistributionFunction> funcs, ArrayList<Double> coeffs) {
        ArrayList<Distribution> ret = new ArrayList<Distribution>();
        for (int i = 0; i < funcs.size(); ++i) {
            ret.add(new Distribution());
        }
        for (Double v : data.getValueToFrequencey().keySet()) {
            ret.get(EMCycle.optimalCluster(v, funcs, coeffs)).add(v, (int)data.getValueToFrequencey().get(v));
        }
        return ret;
    }

    public static int optimalCluster(double v, ArrayList<DistributionFunction> funcs, ArrayList<Double> coeffs) {
        double max = Double.NEGATIVE_INFINITY;
        int ind = -1;
        for (int i = 0; i < funcs.size(); ++i) {
            double l = funcs.get(i).getY(v) * coeffs.get(i);
            if (!(l > max)) continue;
            max = l;
            ind = i;
        }
        return ind;
    }

    public static void main(String[] args) {
        String a = "a";
        if (a instanceof Object) {
            System.out.println(1);
        }
    }

    protected class EMParameterEstimation {
        private ArrayList<Distribution> cluss;
        private ArrayList<DistributionFunction> funcs;
        public ArrayList<DistributionFunction> funcsOut;
        public ArrayList<Double> coeffsOut;

        public EMParameterEstimation(ArrayList<Distribution> cluss, ArrayList<DistributionFunction> funcs) throws DistributionException {
            this.cluss = cluss;
            this.funcs = funcs;
            this.init();
        }

        private void init() throws DistributionException {
            int i;
            this.coeffsOut = new ArrayList();
            int size = 0;
            for (i = 0; i < this.cluss.size(); ++i) {
                size += this.cluss.get(i).size();
            }
            for (i = 0; i < this.cluss.size(); ++i) {
                this.coeffsOut.add((double)this.cluss.get(i).size() / (double)size);
            }
            this.funcsOut = new ArrayList();
            for (i = 0; i < this.cluss.size(); ++i) {
                ParameterEstimation pe = new ParameterEstimation(this.cluss.get(i), this.funcs.get(i));
                this.funcsOut.add(pe.funcOut);
            }
        }
    }
}

