/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.optim.linear;

import fork.lib.math.algebra.advanced.linearalgebra.Matrix;
import fork.lib.math.algebra.advanced.linearalgebra.Vector;

public class SimplexMethod {
    protected Matrix mat0 = new Matrix();
    protected Matrix matcurr = null;
    protected int varnum;
    protected int slacknum;
    protected boolean ifstop = false;
    protected Vector resvec = new Vector();

    public SimplexMethod(Vector tarvec, Matrix constrs, Vector rhs) throws Exception {
        int i;
        Vector v1 = new Vector();
        v1.add(1.0);
        for (Double d : tarvec) {
            v1.add(-d.doubleValue());
        }
        for (i = 0; i < constrs.size() + 1; ++i) {
            v1.add(0.0);
        }
        this.mat0.add(v1);
        for (i = 0; i < constrs.size(); ++i) {
            Vector vec = (Vector)constrs.get(i);
            Vector vn = new Vector();
            vn.add(0.0);
            for (Double d : vec) {
                vn.add(d);
            }
            for (int j = 0; j < constrs.size(); ++j) {
                if (i == j) {
                    vn.add(1.0);
                    continue;
                }
                vn.add(0.0);
            }
            vn.add(rhs.get(i));
            this.mat0.add(vn);
        }
        this.varnum = tarvec.size();
        this.slacknum = constrs.size();
    }

    public void start() throws Exception {
        if (this.matcurr == null) {
            this.matcurr = this.mat0.clone();
        }
        this.matcurr.print();
        System.out.println();
        while (!this.ifstop) {
            this.nextCycle();
        }
        this.resvec = SimplexMethod.computeResultVector(this.matcurr);
    }

    protected void nextCycle() throws Exception {
        int pivcol = -1;
        double pivcolmin = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.matcurr.columnNumber() - 1; ++i) {
            Vector colvec = this.matcurr.getColumn(i);
            double min = colvec.min();
            if (!(min < pivcolmin)) continue;
            pivcolmin = min;
            pivcol = i;
        }
        int pivrow = -1;
        double pivrowmin = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.matcurr.rowNumber(); ++i) {
            Vector rowvec = (Vector)this.matcurr.get(i);
            double v = (Double)rowvec.get(rowvec.size() - 1) / (Double)rowvec.get(pivcol);
            if (!(v > 0.0) || !(v < pivrowmin)) continue;
            pivrow = i;
            pivrowmin = v;
        }
        System.out.println("pcol:" + pivcol + "  prow" + pivrow);
        Vector pivvec = ((Vector)this.matcurr.get(pivrow)).divideScalar((Double)this.matcurr.getRow(pivrow).get(pivcol));
        for (int i = 0; i < this.matcurr.size(); ++i) {
            Vector vec = (Vector)this.matcurr.get(i);
            if (i != pivrow) {
                Vector nvec = vec.add(pivvec.multiplyScalar(-((Double)vec.get(pivcol)).doubleValue()));
                this.matcurr.set(i, nvec);
                continue;
            }
            this.matcurr.set(i, pivvec);
        }
        if (((Vector)this.matcurr.get(0)).min() >= 0.0) {
            this.ifstop = true;
        }
        this.matcurr.print();
        System.out.println();
    }

    protected static Vector computeResultVector(Matrix mat) throws Exception {
        Vector ret = new Vector();
        for (int i = 0; i < mat.columnNumber(); ++i) {
            Vector col = mat.getColumn(i);
            if (col.max() == 1.0 && col.sum() == 1.0) {
                for (int j = 0; j < col.size(); ++j) {
                    if ((Double)col.get(j) != 1.0) continue;
                    Vector row = mat.getRow(j);
                    ret.add(row.get(row.size() - 1));
                }
                continue;
            }
            ret.add(0.0);
        }
        return ret;
    }

    public double getMaximumValue() {
        return (Double)this.resvec.get(0);
    }

    public Vector getMaximisedParameters() throws Exception {
        return this.resvec.subset(1, 3);
    }

    public static void main(String[] args) throws Exception {
        Vector tarvec = new Vector(2.5, 3.0);
        Matrix mat = new Matrix(new double[][]{{-3.0, -5.0}, {-2.0, -1.0}, {-1.0, -1.0}});
        Vector rhs = new Vector(10.0, 3.0, 20.0);
        SimplexMethod ss = new SimplexMethod(tarvec, mat, rhs);
        ss.start();
        System.out.println(ss.getMaximumValue());
        System.out.println(ss.getMaximisedParameters());
    }
}

