/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.stat;

import fork.lib.math.algebra.elementary.set.continuous.Region;
import fork.lib.math.applied.stat.Quantifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class Binning<E> {
    protected Quantifier<E> quant;
    protected ArrayList<E> ents = new ArrayList();

    public Binning(Collection<E> vs, Quantifier<E> quant) throws Exception {
        this.ents.addAll(vs);
        this.quant = quant;
        this.init();
    }

    public Binning(Collection<E> vs) throws Exception {
        this(vs, new Quantifier<E>(){

            @Override
            public double quantify(E e) {
                try {
                    return (Double)e;
                }
                catch (Exception ex1) {
                    try {
                        return ((Integer)e).intValue();
                    }
                    catch (Exception ex2) {
                        try {
                            return Double.parseDouble(e.toString());
                        }
                        catch (Exception ex3) {
                            return e.hashCode();
                        }
                    }
                }
            }
        });
    }

    protected void init() throws Exception {
    }

    public HashMap<Region, ArrayList<E>> getBinnedData(Collection<Region> regs) throws Exception {
        HashMap<Region, ArrayList<E>> ret = new HashMap<Region, ArrayList<E>>();
        for (Region reg : regs) {
            if (!ret.containsKey(reg)) {
                ret.put(reg, new ArrayList());
            }
            for (E e : this.ents) {
                if (!reg.contains(this.quant.quantify(e))) continue;
                ret.get(reg).add(e);
            }
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
    }
}

