/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.stat;

import fork.lib.math.algebra.Algebra1D;
import fork.lib.math.algebra.advanced.linearalgebra.Vector;
import fork.lib.math.algebra.elementary.function.v1.FunctionV1;
import fork.lib.math.algebra.elementary.function.v1.distr.NormalDistribution;
import fork.lib.math.algebra.elementary.function.v1.polynomial.ConstantFunction;
import fork.lib.math.applied.stat.FrequencyCount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Distribution
extends FrequencyCount<Double> {
    public Distribution(double ... vs) {
        this();
        this.add(vs);
    }

    public Distribution(Double ... vs) {
        super(vs);
    }

    public Distribution(Collection<Double> vs) {
        super(vs);
    }

    public Distribution() {
    }

    public HashMap<Double, Integer> getValueToFrequencey() {
        return super.getFrequencyCounts();
    }

    @Override
    public void add(Double v) {
        if (!v.isNaN() && !v.isInfinite()) {
            super.add(v);
        }
    }

    @Override
    public void add(double ... vs) {
        if (vs == null) {
            return;
        }
        for (int i = 0; i < vs.length; ++i) {
            this.add((Double)vs[i]);
        }
    }

    @Override
    public void remove(Double v) {
        if (!v.isNaN() && !v.isInfinite()) {
            super.remove(v);
        }
    }

    @Override
    public void add(Double v, int f) {
        if (f < 0) {
            System.err.println("Negative frequency: " + f);
            return;
        }
        if (v.isInfinite() || v.isNaN()) {
            return;
        }
        if (!this.cs.containsKey(v)) {
            this.cs.put(v, 0);
        }
        this.cs.put(v, new Integer((Integer)this.cs.get(v) + f));
    }

    @Override
    public void add(Distribution d) {
        ArrayList vs = d.keys();
        for (Double v : vs) {
            this.add(v, d.getFrequencyFor(v));
        }
    }

    public boolean isEmpty() {
        return this.cs.isEmpty();
    }

    public double min() {
        return Algebra1D.minOf(this.keys());
    }

    public double max() {
        return Algebra1D.maxOf(this.keys());
    }

    protected int[] values() {
        Iterator it = this.cs.values().iterator();
        int[] vs = new int[this.cs.keySet().size()];
        int ind = 0;
        while (it.hasNext()) {
            Integer v = (Integer)it.next();
            vs[ind] = v;
            ++ind;
        }
        return vs;
    }

    public double[] getDoubles() {
        Iterator it = this.cs.keySet().iterator();
        ArrayList<Double> vs = new ArrayList<Double>();
        while (it.hasNext()) {
            Double v = (Double)it.next();
            Integer fr = (Integer)this.cs.get(v);
            for (int i = 0; i < fr; ++i) {
                vs.add(v);
            }
        }
        double[] ret = new double[vs.size()];
        for (int i = 0; i < vs.size(); ++i) {
            ret[i] = (Double)vs.get(i);
        }
        return ret;
    }

    public int getFrequencyFor(double v) {
        if (!this.cs.containsKey(v)) {
            return 0;
        }
        return (Integer)this.cs.get(v);
    }

    public double range() {
        return new Vector((List<Double>)this.sortedKeys()).range();
    }

    public double sum() {
        Iterator it = this.cs.keySet().iterator();
        double ret = 0.0;
        while (it.hasNext()) {
            Double v = (Double)it.next();
            Integer f = (Integer)this.cs.get(v);
            ret += v * (double)f.intValue();
        }
        return ret;
    }

    public int size() {
        return Algebra1D.sum(this.values());
    }

    public double mean() {
        return this.sum() / (double)this.size();
    }

    public double median() {
        int indTar = this.size() / 2;
        ArrayList vs = this.sortedKeys();
        int ind = 0;
        double ret = Double.NEGATIVE_INFINITY;
        for (Double v : vs) {
            if ((ind += ((Integer)this.cs.get(v)).intValue()) < indTar) continue;
            ret = v;
            break;
        }
        return ret;
    }

    public double variance() {
        double m = this.mean();
        int s = this.size() - 1;
        if (s <= 0) {
            s = 1;
        }
        double ret = 0.0;
        for (Double v : this.cs.keySet()) {
            Integer f = (Integer)this.cs.get(v);
            ret += Math.pow(v - m, 2.0) * (double)f.intValue();
        }
        return ret /= (double)s;
    }

    public double standartDeviation() {
        return Math.sqrt(this.variance());
    }

    public double logLikelihood(FunctionV1 func) {
        double llh = 0.0;
        for (Double v : this.cs.keySet()) {
            Integer f = (Integer)this.cs.get(v);
            double lh = func.getY(v);
            llh += Math.log(lh) * (double)f.intValue();
        }
        return llh;
    }

    public FunctionV1 kernelDensityEstimation(double sigma) {
        try {
            FunctionV1 fn = new ConstantFunction(0.0);
            for (Double v : this.cs.keySet()) {
                Integer f = (Integer)this.cs.get(v);
                double coeff = (double)f.intValue() / (double)this.size();
                fn = fn.add(new NormalDistribution(v, sigma).multiply(new ConstantFunction(coeff)));
            }
            return fn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<Double> quantileBoundaries(int invs) {
        if (invs <= 0) {
            return null;
        }
        ArrayList<Double> probs = new ArrayList<Double>();
        for (int i = 0; i < invs + 1; ++i) {
            probs.add((double)i / (double)invs);
        }
        ArrayList vs = this.sortedKeys();
        double accf = 0.0;
        int size = this.size();
        int ind = 0;
        ArrayList<Double> ret = new ArrayList<Double>();
        for (int i = 0; i < probs.size(); ++i) {
            double prob = (Double)probs.get(i);
            while (ind < vs.size() && !(accf > prob)) {
                accf += (double)((Integer)this.cs.get(vs.get(ind))).intValue() / (double)size;
                ++ind;
            }
            ret.add((Double)vs.get(ind - 1));
        }
        return ret;
    }

    public ArrayList<Distribution> quantileSubsets(int invs) {
        ArrayList<Double> bd = this.quantileBoundaries(invs);
        ArrayList<Distribution> ret = new ArrayList<Distribution>();
        for (int i = 0; i < bd.size() - 1; ++i) {
            boolean inc = i == bd.size() - 2;
            ret.add(this.subset(bd.get(i), bd.get(i + 1), true, inc));
        }
        return ret;
    }

    public Distribution subset(double low, double high, boolean lowInc, boolean highInc) {
        Iterator it = this.cs.keySet().iterator();
        Distribution ret = new Distribution();
        while (it.hasNext()) {
            Double v = (Double)it.next();
            boolean bl = lowInc ? (v >= low ? (highInc ? v <= high : v < high) : false) : (v > low ? (highInc ? v <= high : v < high) : false);
            boolean ift = bl;
            if (!ift) continue;
            ret.add(v, (int)((Integer)this.cs.get(v)));
        }
        return ret;
    }

    public Distribution subsetHigherThan(double b) {
        return this.subset(b, Double.POSITIVE_INFINITY, false, true);
    }

    public Distribution subsetHigherOrEqualTo(double b) {
        return this.subset(b, Double.POSITIVE_INFINITY, true, true);
    }

    public Distribution subsetLowerThan(double b) {
        return this.subset(Double.NEGATIVE_INFINITY, b, true, false);
    }

    public Distribution subsetLowerOrEqualTo(double b) {
        return this.subset(Double.NEGATIVE_INFINITY, b, true, true);
    }

    public Distribution subsetEqualTo(double b) {
        return this.subset(b, b, true, true);
    }

    @Override
    public void print() {
        ArrayList ks = this.sortedKeys();
        for (Double k : ks) {
            System.out.println(k + "   " + this.getFrequencyFor(k));
        }
    }

    public static void main(String[] args) throws Exception {
        NormalDistribution n = new NormalDistribution(10.0, 5.0);
        Distribution d = new Distribution(new double[]{1.0, 2.0, 3.0, 4.0, 5.0});
        System.out.println(d.standartDeviation());
    }
}

