/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.math.applied.stat;

import fork.lib.base.Print;
import fork.lib.base.collection.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public class FrequencyCount<K>
implements Iterable,
Serializable {
    protected HashMap<K, Integer> cs = new HashMap();

    public FrequencyCount(Collection<K> al) {
        this.addAll(al);
    }

    public FrequencyCount(K ... os) {
        this.addAll(os);
    }

    public FrequencyCount() {
    }

    public void add(K k, int n) {
        if (!this.cs.containsKey(k)) {
            this.cs.put(k, new Integer(0));
        }
        this.cs.put(k, new Integer(this.cs.get(k) + n));
    }

    public void add(K k) {
        this.add(k, 1);
    }

    public void remove(K k) {
        if (!this.cs.containsKey(k)) {
            return;
        }
        int nn = new Integer(this.cs.get(k) - 1);
        if (nn <= 0) {
            this.cs.remove(k);
        } else {
            this.cs.put(k, nn);
        }
    }

    public void addAll(Collection ks) {
        Iterator it = ks.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public void addAll(K ... ks) {
        for (int i = 0; i < ks.length; ++i) {
            this.add(ks[i]);
        }
    }

    public HashMap<K, Integer> getFrequencyCounts() {
        return this.cs;
    }

    public K mostFrequentKey() {
        int mfc = Integer.MIN_VALUE;
        K ret = null;
        for (K k : this) {
            int fc = this.getCount(k);
            if (fc <= mfc) continue;
            mfc = fc;
            ret = k;
        }
        return ret;
    }

    public K leastFrequentKey() {
        int mfc = Integer.MAX_VALUE;
        K ret = null;
        for (K k : this) {
            int fc = this.getCount(k);
            if (fc >= mfc) continue;
            mfc = fc;
            ret = k;
        }
        return ret;
    }

    public ArrayList<K> keys() {
        ArrayList<K> ret = new ArrayList<K>();
        ret.addAll(this.cs.keySet());
        return ret;
    }

    public ArrayList<K> sortedKeys() {
        ArrayList<K> ret = this.keys();
        Collections.sort(ret);
        return ret;
    }

    public ArrayList<K> getKeysSortedByCounts() {
        return this.getKeysSortedByCounts(true);
    }

    public ArrayList<K> getKeysSortedByCountsReversed() {
        return this.getKeysSortedByCounts(false);
    }

    private ArrayList<K> getKeysSortedByCounts(final boolean incr) {
        ArrayList<Pair<K, Integer>> kcs = this.keyCount();
        Collections.sort(kcs, new Comparator<Pair<K, Integer>>(){

            @Override
            public int compare(Pair<K, Integer> o1, Pair<K, Integer> o2) {
                if (incr) {
                    return o1.b().compareTo(o2.b());
                }
                return o2.b().compareTo(o1.b());
            }
        });
        ArrayList<K> ret = new ArrayList<K>();
        for (int i = 0; i < kcs.size(); ++i) {
            ret.add(kcs.get(i).a());
        }
        return ret;
    }

    protected ArrayList<Pair<K, Integer>> keyCount() {
        ArrayList<Pair<K, Integer>> kcs = new ArrayList<Pair<K, Integer>>();
        for (K k : this.cs.keySet()) {
            kcs.add(new Pair<K, Integer>(k, this.cs.get(k)));
        }
        return kcs;
    }

    public int totalCounts() {
        Iterator<K> it = this.cs.keySet().iterator();
        int ret = 0;
        while (it.hasNext()) {
            ret += this.cs.get(it.next()).intValue();
        }
        return ret;
    }

    public int keySize() {
        return this.cs.keySet().size();
    }

    public int getCount(K k) {
        return this.cs.get(k);
    }

    public Iterator<K> iterator() {
        return new Iterator<K>(){
            int cind = 0;
            int kind = 0;
            ArrayList<K> ks;
            {
                try {
                    this.ks = FrequencyCount.this.sortedKeys();
                }
                catch (Exception e) {
                    this.ks = FrequencyCount.this.keys();
                }
            }

            @Override
            public boolean hasNext() {
                return this.kind < this.ks.size();
            }

            @Override
            public K next() {
                Object ret = this.ks.get(this.kind);
                int num = FrequencyCount.this.cs.get(ret);
                ++this.cind;
                if (this.cind >= num) {
                    this.cind = 0;
                    ++this.kind;
                }
                return ret;
            }

            @Override
            public void remove() {
            }
        };
    }

    public void print() {
        Print.map(this.getFrequencyCounts());
    }

    public static void main(String[] args) throws Exception {
        FrequencyCount<Integer> fc = new FrequencyCount<Integer>();
        fc.add(1);
        fc.add(1);
        fc.add(1);
        fc.add(1);
        fc.add(2);
        fc.add(2);
        fc.add(2);
        fc.add(2);
        fc.add(2);
        fc.add(2);
        fc.add(20);
        fc.add(245);
        Iterator it = fc.iterator();
        fc.add(-1);
        fc.add(-1);
        fc.add(-1);
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }
}

