/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.base;

public class FTimer {
    public static long MIN = 60000L;
    public static long HOUR = MIN * 60L;
    public static long DAY = HOUR * 24L;
    protected long time = System.currentTimeMillis();

    public String passedTime() {
        long t = System.currentTimeMillis() - this.time;
        TimeStep td = new TimeStep(t, DAY);
        t = td.remain;
        String day = td.v == 0 ? "" : Integer.toString(td.v) + "d";
        TimeStep th = new TimeStep(t, HOUR);
        t = th.remain;
        String hour = th.v == 0 ? "" : Integer.toString(th.v) + "h";
        TimeStep tm = new TimeStep(t, MIN);
        t = tm.remain;
        String min = tm.v == 0 ? "" : Integer.toString(tm.v) + "m";
        String sec = Double.toString((double)Math.round((double)t / 100.0) / 10.0) + "s";
        return day + hour + min + sec;
    }

    public static void main(String[] args) throws Exception {
        FTimer f = new FTimer();
        for (int i = 0; i < 10; ++i) {
            System.out.println(f.passedTime());
            Thread.sleep(2156L);
        }
    }

    class TimeStep {
        public int v = 0;
        public long remain = 0L;

        public TimeStep(long t, long unit) {
            if (t > unit) {
                this.v = (int)Math.floor(t / unit);
                this.remain = t - unit * (long)this.v;
            } else {
                this.remain = t;
            }
        }
    }
}

