/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.base.collection;

import fork.lib.base.collection.Table;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class NamedTable<R, C, V>
extends Table<V> {
    public String DEFAULT = "null";
    protected ArrayList<R> rows = new ArrayList();
    protected ArrayList<C> cols = new ArrayList();
    protected HashMap<R, Integer> rowInds;
    protected HashMap<C, Integer> colInds;

    public NamedTable() {
        this.initRowCol();
    }

    public NamedTable(List<R> rows, List<C> cols, ArrayList<ArrayList<V>> table) throws Exception {
        super(table);
        this.rows.addAll(rows);
        this.cols.addAll(cols);
        this.initRowCol();
        this.checkSize2();
    }

    private void initRowCol() {
        int i;
        if (this.rows == null) {
            this.rows = new ArrayList();
        }
        if (this.cols == null) {
            this.cols = new ArrayList();
        }
        this.rowInds = new HashMap();
        for (i = 0; i < this.rows.size(); ++i) {
            this.rowInds.put(this.rows.get(i), i);
        }
        this.colInds = new HashMap();
        for (i = 0; i < this.cols.size(); ++i) {
            this.colInds.put(this.cols.get(i), i);
        }
    }

    protected void checkSize2() throws Exception {
        if (this.rows.size() != this.rowNumber()) {
            System.err.println("rowNameSize:" + this.rows.size() + " != rowNumber:" + this.rowNumber());
            throw new Exception();
        }
        if (this.cols.size() != this.columnNumber()) {
            System.err.println("cols: " + this.cols.size() + "   table_col: " + this.columnNumber());
            throw new Exception();
        }
    }

    public ArrayList<R> rowNames() {
        return this.rows;
    }

    public ArrayList<C> columnNames() {
        return this.cols;
    }

    public V getValueAt(R row, C col) {
        if (this.rowInds.get(row) == null || this.colInds.get(col) == null) {
            return null;
        }
        return this.getValueAt((R)this.rowInds.get(row), (C)this.colInds.get(col));
    }

    public ArrayList<V> getRow(R row) {
        int ind = this.rowInds.get(row);
        if (ind == -1) {
            return null;
        }
        return this.getRow((R)ind);
    }

    public ArrayList<V> getColumn(C col) {
        int ind = this.colInds.get(col);
        if (ind == -1) {
            return null;
        }
        return this.getColumn((C)ind);
    }

    public void appendRow(R row, List<C> cs, List<V> vs) throws Exception {
        if (cs == null || vs == null) {
            this.appendEmptyRow(row);
        }
        if (cs.size() != vs.size()) {
            System.err.println("col size:" + cs.size() + "  new size:" + vs.size());
            throw new Exception();
        }
        HashMap<C, V> hm = new HashMap<C, V>();
        for (int i = 0; i < cs.size(); ++i) {
            hm.put(cs.get(i), vs.get(i));
        }
        this.appendRow(row, hm);
    }

    public void appendRow(R row, HashMap<C, V> hm) throws Exception {
        if (this.rowInds.containsKey(row)) {
            System.err.println("Row exist: " + row.toString());
            throw new Exception();
        }
        ArrayList<V> vs = new ArrayList<V>();
        for (int i = 0; i < this.cols.size(); ++i) {
            vs.add(hm.get(this.cols.get(i)));
        }
        this.rows.add(row);
        this.rowInds.put(row, this.rows.size() - 1);
        this.addRow(vs);
    }

    public void appendRow(R rn, List<V> vs) throws Exception {
        this.appendRow(rn, this.columnNames(), vs);
    }

    public void appendEmptyRow(R row) throws Exception {
        this.appendRow(row, new ArrayList(), new ArrayList());
    }

    public void appendEmptyRows(List<R> rows) throws Exception {
        for (R r : rows) {
            this.appendEmptyRow(r);
        }
    }

    public void appendColumn(C col, List<R> rs, List<V> vs) throws Exception {
        if (rs == null || vs == null) {
            this.appendEmptyColumn(col);
        }
        if (rs.size() != vs.size()) {
            System.err.println("rs:" + rs.size() + " != vs:" + vs.size());
            throw new Exception();
        }
        HashMap<R, V> hm = new HashMap<R, V>();
        for (int i = 0; i < rs.size(); ++i) {
            hm.put(rs.get(i), vs.get(i));
        }
        this.appendColumn(col, hm);
    }

    public void appendColumn(C col, HashMap<R, V> hm) throws Exception {
        if (this.colInds.containsKey(col)) {
            System.err.println("Column exist: " + col.toString());
            throw new Exception();
        }
        ArrayList<V> vs = new ArrayList<V>();
        for (int i = 0; i < this.rows.size(); ++i) {
            vs.add(hm.get(this.rows.get(i)));
        }
        this.cols.add(col);
        this.colInds.put(col, this.cols.size() - 1);
        this.addColumn(vs);
    }

    public void appendColumn(C col, List<V> vs) throws Exception {
        this.appendColumn(col, this.rowNames(), vs);
    }

    public void appendEmptyColumn(C col) {
        try {
            this.appendColumn(col, new ArrayList(), new ArrayList());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void appendEmptyColumns(List<C> cols) throws Exception {
        for (C c : cols) {
            this.appendEmptyColumn(c);
        }
    }

    public void setValueAt(V val, R row, C col) {
        Integer rind = this.rowInds.get(row);
        Integer cind = this.colInds.get(col);
        if (rind != null && cind != null) {
            this.setValueAt(val, (R)rind, (C)cind);
        }
    }

    public void setRowNameAt(R row, int ind) {
        R old = this.rows.get(ind);
        this.rows.set(ind, row);
        this.rowInds.remove(old);
        this.rowInds.put(row, ind);
    }

    public void setColumnNameAt(C col, int ind) {
        C old = this.cols.get(ind);
        this.cols.set(ind, col);
        this.colInds.remove(old);
        this.colInds.put(col, ind);
    }

    public void replaceRowName(R row, R replacement) {
        Integer ind = this.rowInds.get(row);
        if (ind != null) {
            this.setRowNameAt(replacement, ind);
        }
    }

    public void replaceColumnName(C col, C replacement) {
        Integer ind = this.colInds.get(col);
        if (ind != null) {
            this.setColumnNameAt(replacement, ind);
        }
    }

    public boolean containsRow(R row) {
        return this.rowInds.containsKey(row);
    }

    public boolean containsColumn(C col) {
        return this.colInds.containsKey(col);
    }

    public void replaceValues(V val, V rep) {
        for (int i = 0; i < this.rows.size(); ++i) {
            R r = this.rows.get(i);
            for (int j = 0; j < this.cols.size(); ++j) {
                C c = this.cols.get(j);
                if (!this.getValueAt(r, c).equals(val)) continue;
                this.setValueAt(rep, r, c);
            }
        }
    }

    public void replaceNull(V rep) {
        for (int i = 0; i < this.rows.size(); ++i) {
            R r = this.rows.get(i);
            for (int j = 0; j < this.cols.size(); ++j) {
                C c = this.cols.get(j);
                if (this.getValueAt(r, c) != null) continue;
                this.setValueAt(rep, r, c);
            }
        }
    }

    @Override
    public void reorderRows(int[] inds) throws Exception {
        super.reorderRows(inds);
        ArrayList<R> nrs = new ArrayList<R>();
        for (int i = 0; i < this.rows.size(); ++i) {
            nrs.add(this.rows.get(inds[i]));
        }
        this.rows = nrs;
        this.initRowCol();
    }

    @Override
    public void print() {
        this.print("  ");
    }

    public void print(String sep) {
        int i;
        System.out.print("table");
        for (i = 0; i < this.cols.size(); ++i) {
            System.out.print("  " + this.cols.get(i).toString());
        }
        System.out.println();
        for (i = 0; i < this.rows.size(); ++i) {
            System.out.print(this.rows.get(i));
            ArrayList<V> al = this.getRow((R)i);
            for (int j = 0; j < al.size(); ++j) {
                System.out.print(sep + al.get(j));
            }
            System.out.println();
        }
    }

    public void writeToFile(String out) throws IOException {
        this.writeToFile(new File(out));
    }

    @Override
    public void writeToFile(File out) throws IOException {
        int i;
        DecimalFormat df = new DecimalFormat("#.##");
        out.getAbsoluteFile().getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        bw.write("row");
        for (i = 0; i < this.cols.size(); ++i) {
            bw.write("\t" + this.cols.get(i).toString());
        }
        bw.write("\n");
        for (i = 0; i < this.rows.size(); ++i) {
            R row = this.rows.get(i);
            bw.write(row.toString());
            ArrayList<V> al = this.getRow((R)i);
            for (int j = 0; j < al.size(); ++j) {
                V v = al.get(j);
                String ss = v == null ? this.DEFAULT : (v instanceof Double ? df.format(v) : v.toString());
                bw.write("\t" + ss);
            }
            bw.write("\n");
        }
        bw.close();
    }

    public void sortRow(int col, Comparator<Integer> cp) {
        Integer[] sinds = new Integer[this.als.size()];
        for (int i = 0; i < this.als.size(); ++i) {
            sinds[i] = i;
        }
        Arrays.sort(sinds, cp);
        ArrayList sals = new ArrayList();
        for (int i = 0; i < this.als.size(); ++i) {
            sals.add(this.als.get(sinds[i]));
        }
        this.als = sals;
        ArrayList<R> srs = new ArrayList<R>();
        for (int i = 0; i < this.rows.size(); ++i) {
            srs.add(this.rows.get(sinds[i]));
        }
        this.rows = srs;
        this.initRowCol();
    }

    @Override
    public void sortByColumn(final int col) {
        Comparator<Integer> cp = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                try {
                    Double v1 = Double.parseDouble(((ArrayList)NamedTable.this.als.get(o1)).get(col).toString());
                    Double v2 = Double.parseDouble(((ArrayList)NamedTable.this.als.get(o2)).get(col).toString());
                    return v1.compareTo(v2);
                }
                catch (Exception e) {
                    return ((ArrayList)NamedTable.this.als.get(o1)).get(col).toString().compareTo(((ArrayList)NamedTable.this.als.get(o2)).get(col).toString());
                }
            }
        };
        this.sortRow(col, cp);
    }

    @Override
    public void sortByColumnHighToLow(final int col) {
        Comparator<Integer> cp = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                try {
                    Double v1 = Double.parseDouble(((ArrayList)NamedTable.this.als.get(o1)).get(col).toString());
                    Double v2 = Double.parseDouble(((ArrayList)NamedTable.this.als.get(o2)).get(col).toString());
                    return v2.compareTo(v1);
                }
                catch (Exception e) {
                    return ((ArrayList)NamedTable.this.als.get(o2)).get(col).toString().compareTo(((ArrayList)NamedTable.this.als.get(o1)).get(col).toString());
                }
            }
        };
        this.sortRow(col, cp);
    }

    public void sortByColumn(C c) {
        this.sortByColumn(this.colInds.get(c));
    }

    public void sortByColumnHighToLow(C c) {
        this.sortByColumnHighToLow(this.colInds.get(c));
    }

    public static void main(String[] args) throws Exception {
        NamedTable<String, String, Object> nt = new NamedTable<String, String, Object>();
        ArrayList<String> cs = new ArrayList<String>();
        cs.add("v1");
        cs.add("v2");
        cs.add("v3");
        cs.add("v4");
        nt.appendEmptyColumn("v1");
        nt.appendEmptyColumn("v2");
        nt.appendEmptyColumn("v3");
        nt.appendEmptyColumn("v4");
        ArrayList<Double> vs3 = new ArrayList<Double>();
        vs3.add(5.0);
        vs3.add(10.0);
        vs3.add(20.0);
        vs3.add(40.0);
        nt.appendRow("a5.0", cs, vs3);
        ArrayList<Double> vs = new ArrayList<Double>();
        vs.add(1.0);
        vs.add(3.0);
        vs.add(5.0);
        vs.add(7.0);
        nt.appendRow("b1.0", cs, vs);
        ArrayList<Double> vs2 = new ArrayList<Double>();
        vs2.add(2.0);
        vs2.add(4.0);
        vs2.add(6.0);
        vs2.add(8.0);
        nt.appendRow("c2.0", cs, vs2);
        ArrayList<Double> vs4 = new ArrayList<Double>();
        vs4.add(-1.0);
        vs4.add(200.0);
        vs4.add(2.0);
        vs4.add(0.0);
        nt.appendRow("d-1.0", cs, vs4);
        ArrayList<Double> vs5 = new ArrayList<Double>();
        vs5.add(-1.0);
        vs5.add(200.0);
        vs5.add(2.0);
        vs5.add(0.0);
        nt.appendRow("e-1.0", cs, vs5);
        nt.appendEmptyColumn("sfd");
        nt.replaceNull(100.3);
        nt.print();
        System.out.println();
    }
}

