/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.base.collection;

import fork.lib.base.collection.NamedTable;
import fork.lib.base.file.io.txt.WriteTable;
import fork.lib.base.file.io.txt.WriteTableParam;
import fork.lib.base.format.collection.ArrayOp1D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class Table<V> {
    protected ArrayList<ArrayList<V>> als = new ArrayList();
    protected int rowNum = 0;
    protected int colNum = 0;

    public Table() {
    }

    public Table(ArrayList<ArrayList<V>> tab) throws Exception {
        this.als = tab;
        this.init();
    }

    public Table(V[][] tab) throws Exception {
        for (int i = 0; i < tab.length; ++i) {
            V[] row = tab[i];
            ArrayList<V> ra = new ArrayList<V>();
            ra.addAll(Arrays.asList(row));
            this.als.add(ra);
        }
        this.init();
    }

    protected void init() throws Exception {
        if (this.als == null) {
            this.als = new ArrayList();
        }
        for (int i = 0; i < this.als.size(); ++i) {
            ArrayList<V> al = this.als.get(i);
            if (al != null) continue;
            this.als.set(i, new ArrayList());
        }
        this.checkSize();
        this.rowNum = this.als.size();
        this.colNum = this.als.isEmpty() ? 0 : this.als.get(0).size();
    }

    public void setNullValues(V v) {
        for (int i = 0; i < this.als.size(); ++i) {
            ArrayList<V> r = this.als.get(i);
            for (int j = 0; j < r.size(); ++j) {
                V val = r.get(j);
                if (val != null) continue;
                this.setValueAt(v, i, j);
            }
        }
    }

    protected void checkSize() throws Exception {
        int i;
        if (this.als.isEmpty()) {
            return;
        }
        int maxs = 0;
        for (i = 0; i < this.als.size(); ++i) {
            int s = this.als.get(i).size();
            if (s <= maxs) continue;
            maxs = s;
        }
        for (i = 0; i < this.als.size(); ++i) {
            while (this.als.get(i).size() < maxs) {
                this.als.get(i).add(null);
            }
        }
    }

    public int rowNumber() {
        return this.rowNum;
    }

    public int columnNumber() {
        return this.colNum;
    }

    public ArrayList<V> getRow(int ind) {
        return this.als.get(ind);
    }

    public int size() {
        return this.als.size();
    }

    public ArrayList<V> getColumn(int ind) {
        if (ind == -1) {
            ind = this.columnNumber() - 1;
        }
        ArrayList<V> ret = new ArrayList<V>();
        for (int i = 0; i < this.als.size(); ++i) {
            ret.add(this.als.get(i).get(ind));
        }
        return ret;
    }

    public V getValueAt(int r, int c) {
        if (r >= this.rowNum || c >= this.colNum) {
            return null;
        }
        return this.als.get(r).get(c);
    }

    public void addRowAt(Collection<V> vs, int ind) throws Exception {
        if (vs == null) {
            return;
        }
        boolean ifp = false;
        if (this.colNum == 0) {
            ifp = true;
            this.colNum = vs.size();
        } else if (vs.size() == this.colNum) {
            ifp = true;
        }
        if (ifp) {
            ArrayList<V> adr = new ArrayList<V>();
            adr.addAll(vs);
            this.als.add(ind, adr);
            ++this.rowNum;
        } else {
            System.err.println("row:" + ind + "  " + vs);
            throw new Exception();
        }
    }

    public void addRow(Collection<V> vs) throws Exception {
        this.addRowAt(vs, this.rowNum);
    }

    public void addRow(V ... vs) throws Exception {
        ArrayList<V> al = new ArrayList<V>();
        for (int i = 0; i < vs.length; ++i) {
            al.add(vs[i]);
        }
        this.addRow((Collection<V>)al);
    }

    public void removeRow(int ind) throws Exception {
        try {
            if (ind == -1) {
                ind = this.als.size() - 1;
            }
            this.als.remove(ind);
            --this.rowNum;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addColumnAt(List<V> vs, int ind) throws Exception {
        if (vs == null) {
            return;
        }
        if (this.rowNum == 0) {
            for (int i = 0; i < vs.size(); ++i) {
                ArrayList<V> row = new ArrayList<V>();
                row.add(vs.get(i));
                this.addRow((Collection<V>)row);
            }
            return;
        }
        if (vs.size() != this.rowNum) {
            throw new Exception();
        }
        for (int i = 0; i < this.als.size(); ++i) {
            this.als.get(i).add(ind, vs.get(i));
        }
        ++this.colNum;
    }

    public void addColumn(List<V> vs) throws Exception {
        this.addColumnAt(vs, this.colNum);
    }

    public void setValueAt(V val, int rind, int cind) {
        this.als.get(rind).set(cind, val);
    }

    public void print() {
        for (int i = 0; i < this.als.size(); ++i) {
            ArrayList<V> al = this.als.get(i);
            for (int j = 0; j < al.size(); ++j) {
                V v = al.get(j);
                System.out.print(v + "\t");
            }
            System.out.println();
        }
    }

    public static <V> Table<V> parsetTable(V[][] vss) throws Exception {
        Table ret = new Table();
        if (vss != null) {
            for (int i = 0; i < vss.length; ++i) {
                ArrayList<V> al = new ArrayList<V>();
                al.addAll(Arrays.asList(vss[i]));
                ret.addRow((Collection<V>)al);
            }
        }
        return ret;
    }

    public void reorderRows(int[] inds) throws Exception {
        int i;
        if (inds.length != this.rowNum) {
            throw new Exception();
        }
        HashSet<Integer> set = new HashSet<Integer>();
        for (i = 0; i < inds.length; ++i) {
            set.add(inds[i]);
        }
        for (i = 0; i < this.rowNum; ++i) {
            if (set.contains(i)) continue;
            throw new Exception();
        }
        ArrayList<ArrayList<V>> nals = new ArrayList<ArrayList<V>>();
        for (int i2 = 0; i2 < inds.length; ++i2) {
            nals.add(this.als.get(inds[i2]));
        }
        this.als = nals;
    }

    public ArrayList<ArrayList<V>> getArrayList() {
        return this.als;
    }

    public void sortByColumn(final int col) {
        Comparator<ArrayList> comp = new Comparator<ArrayList>(){

            @Override
            public int compare(ArrayList o1, ArrayList o2) {
                try {
                    Double v1 = Double.parseDouble(o1.get(col).toString());
                    Double v2 = Double.parseDouble(o2.get(col).toString());
                    return v1.compareTo(v2);
                }
                catch (Exception e) {
                    return o1.get(col).toString().compareTo(o2.get(col).toString());
                }
            }
        };
        Collections.sort(this.als, comp);
    }

    public void sortByColumn(int col, Comparator<ArrayList<V>> comp) {
        Collections.sort(this.als, comp);
    }

    public void sortByColumnHighToLow(final int col) {
        Comparator<ArrayList> comp = new Comparator<ArrayList>(){

            @Override
            public int compare(ArrayList o1, ArrayList o2) {
                try {
                    Double v1 = Double.parseDouble(o1.get(col).toString());
                    Double v2 = Double.parseDouble(o2.get(col).toString());
                    return v2.compareTo(v1);
                }
                catch (Exception e) {
                    return o2.get(col).toString().compareTo(o1.get(col).toString());
                }
            }
        };
        Collections.sort(this.als, comp);
    }

    public static <V> Table<V> parsetTable(ArrayList<ArrayList<V>> vss) throws Exception {
        Table<V> ret = new Table<V>();
        if (vss != null) {
            for (int i = 0; i < vss.size(); ++i) {
                ret.addRow((Collection)vss.get(i));
            }
        }
        return ret;
    }

    public void writeToFile(File out, String sep) throws Exception {
        WriteTableParam par = new WriteTableParam();
        par.sep = sep;
        WriteTable wt = new WriteTable(this, par);
        wt.writeToFile(out);
    }

    public void writeToFile(File out) throws Exception {
        this.writeToFile(out, "\t");
    }

    public NamedTable<String, String, V> toNamedTable() throws Exception {
        int i;
        ArrayList<String> rns = new ArrayList<String>();
        ArrayList<String> cns = new ArrayList<String>();
        ArrayList vals = new ArrayList();
        for (i = 1; i < this.columnNumber(); ++i) {
            cns.add(this.als.get(0).get(i).toString());
        }
        for (i = 1; i < this.rowNumber(); ++i) {
            ArrayList<V> r = this.als.get(i);
            rns.add(r.get(0).toString());
            vals.add(ArrayOp1D.subset(r, 1, -1));
        }
        return new NamedTable(rns, cns, vals);
    }

    public static void main(String[] args) throws Exception {
        ArrayList<Double> al = new ArrayList<Double>();
        al.add(1.0);
        al.add(2.0);
        ArrayList<ArrayList<Double>> c = new ArrayList<ArrayList<Double>>();
        c.add(al);
        Table t = new Table();
        t.print();
    }
}

