/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.base.file;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class FileName {
    public static char defaultRepl = (char)95;
    public static HashSet<Character> validChars = new HashSet();
    public static HashMap<Character, Character> specialRepl = new HashMap();

    private static String baseNameForFilename(String n) {
        int ind = n.lastIndexOf(".");
        if (ind == -1) {
            return n;
        }
        return n.substring(0, ind);
    }

    public static String baseName(Path p) {
        return FileName.baseNameForFilename(p.getFileName().toString());
    }

    public static String baseName(File f) {
        String n = f.getName();
        return FileName.baseName(f.toPath());
    }

    public static String baseName(String s) {
        return FileName.baseName(Paths.get(s, new String[0]));
    }

    private static String extensionForFilename(String n) {
        int ind = n.lastIndexOf(".");
        if (ind == -1) {
            return "";
        }
        if (ind == n.length() - 1) {
            return "";
        }
        return n.substring(ind + 1);
    }

    public static String extension(Path p) {
        return FileName.extensionForFilename(p.getFileName().toString());
    }

    public static String extension(File f) {
        return FileName.extension(f.toPath());
    }

    public static String extension(String s) {
        return FileName.extension(Paths.get(s, new String[0]));
    }

    public static String fileName(Path p) {
        return p.getFileName().toString();
    }

    public static String fileName(String s) {
        return FileName.fileName(Paths.get(s, new String[0]));
    }

    public static String validName(String fn) {
        char[] cs = fn.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            char c = cs[i];
            if (validChars.contains(Character.valueOf(cs[i]))) continue;
            cs[i] = specialRepl.containsKey(Character.valueOf(c)) ? specialRepl.get(Character.valueOf(c)).charValue() : defaultRepl;
        }
        return new String(cs);
    }

    public static void main(String[] args) throws Exception {
        String s = "/usr/bin/sh";
        Path p = Paths.get(s, new String[0]);
        System.out.println(FileSystems.getDefault().getSeparator());
        System.out.println(Paths.get(s, "sf"));
    }

    static {
        validChars.addAll(Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('0'), Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('#')));
        specialRepl.put(Character.valueOf('+'), Character.valueOf('p'));
    }
}

