/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.base.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileOp {
    public static void moveDirTo(File dirFrom, File dirTo) {
        FileOp.moveDirTo(dirFrom, dirTo, false);
    }

    public static void moveDirTo(File dirFrom, File dirTo, boolean ifMoveRoot) {
        dirTo.mkdirs();
        if (ifMoveRoot) {
            dirTo = new File(dirTo + "/" + dirFrom.getName());
            FileOp.moveDirTo(dirFrom, dirTo, false);
            dirFrom.delete();
        } else {
            File[] fs = dirFrom.listFiles();
            for (int i = 0; i < fs.length; ++i) {
                if (fs[i].isFile()) {
                    fs[i].renameTo(new File(dirTo + "/" + fs[i].getName()));
                    continue;
                }
                if (!fs[i].isDirectory()) continue;
                FileOp.moveDirTo(fs[i], dirTo, true);
            }
        }
    }

    public static void unlinkAll(File dir) {
        FileOp.unlinkAll(dir, false);
    }

    public static void unlinkAll(File dir, boolean ifDeleteRoot) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                files[i].delete();
                continue;
            }
            if (!files[i].isDirectory() || files[i].delete()) continue;
            FileOp.unlinkAll(files[i], true);
        }
        if (ifDeleteRoot) {
            dir.delete();
        }
    }

    public static void copyDirTo(File dirFrom, File dirTo) throws FileNotFoundException, IOException {
        FileOp.copyDirTo(dirFrom, dirTo, false);
    }

    public static void copyDirTo(File dirFrom, File dirTo, boolean ifMoveRoot) throws FileNotFoundException, IOException {
        if (dirFrom.isDirectory()) {
            dirTo.mkdirs();
            if (ifMoveRoot) {
                dirTo = new File(dirTo + "/" + dirFrom.getName());
                FileOp.copyDirTo(dirFrom, dirTo, false);
            } else {
                File[] files = dirFrom.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isFile()) {
                        FileOp.copyFileTo(files[i], dirTo, null);
                        continue;
                    }
                    if (!files[i].isDirectory()) continue;
                    FileOp.copyDirTo(files[i], dirTo, true);
                }
            }
        } else {
            FileOp.copyFileTo(dirFrom, dirTo, null);
        }
    }

    public static void copyFileTo(File f, File dirTo, String name) throws FileNotFoundException, IOException {
        File of;
        dirTo.mkdirs();
        File file = of = name == null ? new File(dirTo + "/" + f.getName()) : new File(dirTo + "/" + name);
        if (name != null || !f.getAbsolutePath().equals(of.getAbsolutePath())) {
            int len;
            FileInputStream in = new FileInputStream(f);
            FileOutputStream out = new FileOutputStream(of);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    public static void main(String[] args) throws Exception {
        FileOp.copyFileTo(new File("test/a.txt"), new File("test"), "b.txt");
    }
}

