/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.base.file.io.txt;

import fork.lib.base.file.io.txt.ChunkEntry;
import fork.lib.base.file.io.txt.ChunkReaderParam;
import fork.lib.base.file.io.txt.DefaultChunkReaderParam;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;

public class ChunkReader
implements Closeable {
    protected BufferedReader br;
    protected String buffline = "";
    protected ArrayList<String> buff = new ArrayList();
    protected ArrayList<String> comments = new ArrayList();
    protected ChunkReaderParam par;

    public ChunkReader(String f) throws Exception {
        this(f, false, null);
    }

    public ChunkReader(String f, boolean ifgz) throws Exception {
        this(f, ifgz, null);
    }

    public ChunkReader(String f, boolean ifgz, ChunkReaderParam par) throws Exception {
        if (ifgz) {
            InputStreamReader decoder = new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(f)), "UTF-8");
            this.br = new BufferedReader(decoder);
        } else {
            this.br = new BufferedReader(new FileReader(f));
        }
        this.par = par;
        if (this.par == null) {
            this.par = this.defaultParam();
        }
    }

    protected ChunkReaderParam defaultParam() throws Exception {
        return new DefaultChunkReaderParam();
    }

    public ChunkEntry nextEntry() throws Exception {
        if (this.buffline == null) {
            return null;
        }
        if (!this.buffline.isEmpty()) {
            this.buff.add(this.buffline);
        }
        while (true) {
            this.buffline = this.br.readLine();
            this.onReadLine();
            if (this.buffline == null) {
                if (!this.buff.isEmpty()) {
                    return this.flush();
                }
                return null;
            }
            if (this.par.isComment(this.buffline)) {
                this.comments.add(this.buffline);
                continue;
            }
            if (this.par.isChunkStart(this.buffline)) {
                if (this.buff.isEmpty()) {
                    this.buff.add(this.buffline);
                    continue;
                }
                return this.flush();
            }
            this.buff.add(this.buffline);
        }
    }

    protected void onReadLine() {
    }

    protected ChunkEntry flush() {
        ChunkEntry ret = new ChunkEntry(this.buff);
        this.buff = new ArrayList();
        return ret;
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }

    public BufferedReader bufferedReader() {
        return this.br;
    }

    public static void main(String[] args) throws Exception {
    }
}

