/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.base.file.io.txt;

import fork.lib.base.collection.Table;
import fork.lib.base.file.io.txt.ReadTableParam;
import fork.lib.base.format.collection.FormatOp1D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class ReadTable {
    protected File file;
    protected boolean ifInit = false;
    protected ReadTableParam par;
    protected ArrayList<String> skippedRows = new ArrayList();
    protected Table<String> tab = new Table();

    public ReadTable(File file) throws IOException {
        this(file, null);
    }

    public ReadTable(String path) throws IOException {
        this(new File(path), null);
    }

    public ReadTable(String path, ReadTableParam par) throws IOException {
        this(new File(path), par);
    }

    public ReadTable(File file, ReadTableParam par) throws IOException {
        this.file = file;
        this.par = par;
        if (this.par == null) {
            this.par = new ReadTableParam();
        }
    }

    private void init() throws Exception {
        String l;
        BufferedReader br = new BufferedReader(new FileReader(this.file));
        int ind = 0;
        while ((l = br.readLine()) != null) {
            if (!this.par.ifSkip(l)) {
                if (!this.par.skipRows.contains(ind)) {
                    if (!l.equals("")) {
                        this.tab.addRow((Collection<String>)Arrays.asList(l.split(this.par.sep, -1)));
                    }
                } else {
                    this.skippedRows.add(l);
                }
                ++ind;
                continue;
            }
            this.skippedRows.add(l);
        }
        br.close();
        this.ifInit = true;
    }

    public String[][] getTableAsArray() throws Exception {
        if (!this.ifInit) {
            this.init();
        }
        String[][] ret = new String[this.tab.rowNumber()][];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = FormatOp1D.arrayListToString(this.tab.getRow(i));
        }
        return ret;
    }

    public Table<String> getTable() throws Exception {
        if (!this.ifInit) {
            this.init();
        }
        return this.tab;
    }

    public ArrayList<String> getCommentedRows() throws Exception {
        if (this.skippedRows == null) {
            this.init();
        }
        return this.skippedRows;
    }

    public String[] getColumn(int col) throws Exception {
        if (!this.ifInit) {
            this.init();
        }
        return FormatOp1D.arrayListToString(this.tab.getColumn(col));
    }

    public ArrayList<String> getColumnArray(int col) throws Exception {
        if (!this.ifInit) {
            this.init();
        }
        return this.tab.getColumn(col);
    }

    public ReadTableParam param() {
        return this.par;
    }

    public void setSkipCols(int ... s) {
        this.par.setSkipCols(s);
    }

    public void setSkipRows(int ... s) {
        this.par.setSkipRows(s);
    }

    public void setParam(ReadTableParam par) {
        this.par = par;
    }

    public HashMap<String, String> getHashMap(int from, int to) throws Exception {
        HashMap<String, String> ret = new HashMap<String, String>();
        Table<String> tab = this.getTable();
        for (int i = 0; i < tab.rowNumber(); ++i) {
            ArrayList<String> r = tab.getRow(i);
            if (r.size() <= from || r.size() <= to) continue;
            ret.put(r.get(from), r.get(to));
        }
        return ret;
    }

    public HashSet<String> getHashSet(int col) throws Exception {
        String[] vs = this.getColumn(col);
        HashSet<String> ret = new HashSet<String>();
        for (int i = 0; i < vs.length; ++i) {
            ret.add(vs[i]);
        }
        return ret;
    }

    public static Table<String> parseTable(String tabs, String rowSep, String colSep) throws Exception {
        Table<String> ret = new Table<String>();
        String[] rows = tabs.split(rowSep);
        for (int i = 0; i < rows.length; ++i) {
            String row = rows[i];
            String[] cols = row.split(colSep);
            ArrayList<String> colsal = new ArrayList<String>();
            colsal.addAll(Arrays.asList(cols));
            ret.addRow((Collection<String>)colsal);
        }
        return ret;
    }

    public static Table<String> parseTable(ArrayList<String> tabs, String colSep) throws Exception {
        Table<String> ret = new Table<String>();
        for (int i = 0; i < tabs.size(); ++i) {
            String row = tabs.get(i);
            String[] cols = row.split(colSep);
            ArrayList<String> colsal = new ArrayList<String>();
            colsal.addAll(Arrays.asList(cols));
            ret.addRow((Collection<String>)colsal);
        }
        return ret;
    }

    public ArrayList<String> getSkippedRows() {
        return this.skippedRows;
    }

    public static void main(String[] args) throws Exception {
        File f = new File("G:/Biochem/Teichmann/prog/NetBeansProjects/epichip_gui/mm9_refseq_20110302.txt");
        ReadTable r = new ReadTable(f);
        r.setSkipCols(1, 2, 3, 4, 5, 6, 7, 8, 9);
        String[][] ss = r.getTableAsArray();
        for (int i = 0; i < ss.length; ++i) {
            for (int j = 0; j < ss[i].length; ++j) {
                System.out.print(ss[i][j] + "  ");
            }
            System.out.println();
        }
    }
}

