/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.base.file.io.txt;

import fork.lib.base.collection.NamedTable;
import fork.lib.base.collection.Table;
import fork.lib.base.file.io.txt.WriteTableParam;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;

public class WriteTable<E> {
    protected Table<E> tab;
    protected WriteTableParam par;

    public WriteTable(Table<E> tab, WriteTableParam par) {
        this.tab = tab;
        this.init();
    }

    public WriteTable(Table<E> tab) {
        this(tab, null);
    }

    protected void init() {
        if (this.par == null) {
            this.par = new WriteTableParam();
        }
    }

    public WriteTableParam param() {
        return this.par;
    }

    public void setParam(WriteTableParam par) {
        this.par = par;
    }

    public void writeToFile(File out) throws Exception {
        NamedTable nt;
        out.getAbsoluteFile().getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        for (String c : this.par.commentRows) {
            bw.write(c + "\n");
        }
        boolean ifnt = this.tab instanceof NamedTable;
        NamedTable namedTable = nt = ifnt ? (NamedTable)this.tab : null;
        if (ifnt && this.par.writeColumnNames) {
            this.writeObjectRow(nt.rowNames(), bw);
        }
        for (int i = 0; i < this.tab.rowNumber(); ++i) {
            bw.write(ifnt && this.par.writeRowNames ? nt.rowNames().get(i).toString() + "\t" : "");
            this.writeRow(this.tab.getRow(i), bw);
        }
        bw.close();
    }

    private void writeObjectRow(ArrayList row, BufferedWriter bw) throws Exception {
        for (int i = 0; i < row.size(); ++i) {
            String suf = i == row.size() - 1 ? "\n" : "\t";
            bw.write(row.get(i).toString());
            bw.write(suf);
        }
    }

    private void writeRow(ArrayList<E> row, BufferedWriter bw) throws Exception {
        for (int i = 0; i < row.size(); ++i) {
            String suf = i == row.size() - 1 ? "\n" : "\t";
            bw.write(this.elementString(row.get(i)));
            bw.write(suf);
        }
    }

    protected String elementString(E ele) throws Exception {
        return ele.toString();
    }
}

