/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.base.format;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteOp {
    public static char[] byteArrayToCharArray(byte[] ba) {
        char[] ret = new char[ba.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (char)ba[i];
        }
        return ret;
    }

    public static byte[] charArrayToByteArray(char[] ca) {
        byte[] ret = new byte[ca.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)ca[i];
        }
        return ret;
    }

    public static int byteArrayToInt(byte[] ba) {
        return (ba[0] & 0xFF) << 24 | (ba[1] & 0xFF) << 16 | (ba[2] & 0xFF) << 8 | ba[3] & 0xFF;
    }

    public static byte[] intToByteArray(int v) {
        return ByteBuffer.allocate(4).putInt(v).array();
    }

    public static String byteArrayToString(byte[] bs) {
        return new String(ByteOp.byteArrayToCharArray(bs));
    }

    public static byte[] stringToByteArray(String s) {
        return ByteOp.charArrayToByteArray(s.toCharArray());
    }

    public static float byteArrayToFloatBigEndian(byte[] ba) {
        return ByteBuffer.wrap(ba).order(ByteOrder.BIG_ENDIAN).getFloat();
    }

    public static float byteArrayToFloatLittleEndian(byte[] ba) {
        return ByteBuffer.wrap(ba).order(ByteOrder.LITTLE_ENDIAN).getFloat();
    }

    public static byte[] floatToByteArray(float v) {
        return ByteBuffer.allocate(4).putFloat(v).array();
    }

    public static void main(String[] args) throws Exception {
        float v = 1.5f;
        System.out.println(v);
        byte[] ba = ByteOp.floatToByteArray(v);
        System.out.println(ba);
        System.out.println(ByteOp.byteArrayToFloatBigEndian(ba));
    }
}

