/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.base.format;

import fork.lib.base.format.collection.ArrayOp1D;
import java.util.ArrayList;

public class StringOp {
    public static String substringBetween(String s, String left, String right) {
        int l = s.indexOf(left);
        int r = s.indexOf(right, l + 1);
        return l == -1 ? null : (r == -1 ? null : s.substring(l + left.length(), r));
    }

    public static String substringBefore(String s, String mark) {
        int i = s.indexOf(mark);
        return i == -1 ? null : s.substring(0, i);
    }

    public static String substringAfter(String s, String mark) {
        int i = s.indexOf(mark);
        int si = i + mark.length();
        return i == -1 ? null : s.substring(si, s.length());
    }

    public static String repeat(String rep, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(rep);
        }
        return sb.toString();
    }

    public static String fill(String str, String fill, int len) {
        if (fill == null || fill.length() == 0) {
            return str;
        }
        while (str.length() < len) {
            str = str + fill;
        }
        return str;
    }

    public static String join(String sep, String ... ss) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ss.length; ++i) {
            sb.append(ss[i]);
            if (i == ss.length - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static String join(ArrayList ss, String sep, int low, int high) {
        return ArrayOp1D.join(ss, sep, low, high);
    }

    public static String join(ArrayList ss, String sep) {
        return StringOp.join(ss, sep, 0, ss.size() - 1);
    }

    public static String invert(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = s.length() - 1; i >= 0; --i) {
            sb.append(s.charAt(i));
        }
        return sb.toString();
    }

    public static String trimFromLeft(String tag, String s) {
        int ind;
        if (!s.contains(tag)) {
            return s;
        }
        while ((ind = s.indexOf(tag)) == 0) {
            s = s.substring(tag.length());
        }
        return s;
    }

    public static String trimFromRight(String tag, String s) {
        int ind;
        if (!s.contains(tag)) {
            return s;
        }
        while ((ind = s.indexOf(tag)) == s.length() - tag.length()) {
            s = s.substring(0, ind);
        }
        return s;
    }

    public static String trimFromEnds(String tag, String s) {
        s = StringOp.trimFromLeft(tag, s);
        return StringOp.trimFromRight(tag, s);
    }

    public static void main(String[] args) throws Exception {
        String s = "s\tss\t\t\t\t\ts\t\t\t\t";
        String[] ss = s.split("\t");
        for (int i = 0; i < ss.length; ++i) {
            System.out.println(ss[i]);
        }
    }
}

