/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.base.format.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ArrayOp1D {
    public static <V> ArrayList<V> subset(ArrayList<V> vs, int from, int to) {
        if (to == -1) {
            to = vs.size();
        }
        ArrayList<V> ret = new ArrayList<V>();
        for (int i = 0; i < vs.size(); ++i) {
            if (i < from || i >= to) continue;
            ret.add(vs.get(i));
        }
        return ret;
    }

    public static boolean isIn(String s, String[] arr) {
        boolean ret = false;
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(s)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    public static ArrayList invert(ArrayList al) {
        if (al == null) {
            return null;
        }
        ArrayList ret = new ArrayList();
        for (int i = al.size() - 1; i >= 0; --i) {
            ret.add(al.get(i));
        }
        return ret;
    }

    public static String join(ArrayList ss, String sep, int low, int high) {
        if (high == -1) {
            high = ss.size() - 1;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = low; i <= high; ++i) {
            sb.append(ss.get(i).toString());
            if (i == ss.size() - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static String join(ArrayList ss, String sep) {
        return ArrayOp1D.join(ss, sep, 0, ss.size() - 1);
    }

    public static String join(String[] ss, String sep, int low, int high) {
        StringBuilder sb = new StringBuilder();
        if (high == -1) {
            high = ss.length;
        }
        for (int i = low; i < high; ++i) {
            sb.append(ss[i]);
            if (i == ss.length - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static <E> ArrayList<E> repeat(E ele, int n) {
        ArrayList<E> ret = new ArrayList<E>();
        for (int i = 0; i < n; ++i) {
            ret.add(ele);
        }
        return ret;
    }

    public static <V> ArrayList<ArrayList<V>> split(ArrayList<V> arr, V spl) {
        ArrayList<ArrayList<V>> ret = new ArrayList<ArrayList<V>>();
        ArrayList<V> cw = new ArrayList<V>();
        for (V v : arr) {
            if (v.equals(spl)) {
                ret.add(cw);
                cw = new ArrayList();
                continue;
            }
            cw.add(v);
        }
        if (!cw.isEmpty()) {
            ret.add(cw);
        }
        return ret;
    }

    public static <V> ArrayList<V> unique(ArrayList<V> vs) {
        HashSet<V> set = new HashSet<V>();
        for (V v : vs) {
            set.add(v);
        }
        ArrayList<V> ret = new ArrayList<V>();
        ret.addAll(set);
        return ret;
    }

    public static <V> ArrayList<V> remove(ArrayList<V> arr, V rem) {
        ArrayList<V> ret = new ArrayList<V>();
        for (V v : arr) {
            if (v.equals(rem)) continue;
            ret.add(v);
        }
        return ret;
    }

    public static int index(List li, Object ele) {
        for (int i = 0; i < li.size(); ++i) {
            if (!li.get(i).equals(ele)) continue;
            return i;
        }
        return -1;
    }

    public static <V> void replace(List<V> al, V tar, V rep) {
        for (int i = 0; i < al.size(); ++i) {
            V v = al.get(i);
            if (!v.equals(tar)) continue;
            al.set(i, rep);
        }
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> ss = new ArrayList<String>();
        ss.addAll(Arrays.asList("a", "a", "b", "c", "b"));
        System.out.println(ss);
        ArrayOp1D.replace(ss, "b", "x");
        System.out.println(ss);
    }
}

