/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.base.time;

public class Time {
    public static char DAY = (char)100;
    public static char HOUR = (char)104;
    public static char MIN = (char)109;
    public static char SEC = (char)115;
    protected int day = 0;
    protected int hour = 0;
    protected int min = 0;
    protected int sec = 0;
    protected boolean ifClean = true;

    public Time() {
    }

    public Time(int day, int hour, int min, int sec) {
        this.setDay(day);
        this.setHour(hour);
        this.setMinute(min);
        this.setSecond(sec);
    }

    public Time(int sec) {
        this(0, 0, 0, sec);
    }

    public void setDay(int b) {
        this.day = b;
        this.ifClean = false;
    }

    public void addDay(int b) {
        this.day = this.day += b;
        this.ifClean = false;
    }

    public void setHour(int b) {
        this.hour = b;
        this.ifClean = false;
    }

    public void addHour(int b) {
        this.hour = this.hour += b;
        this.ifClean = false;
    }

    public void setMinute(int b) {
        this.min = b;
        this.ifClean = false;
    }

    public void addMinute(int b) {
        this.min = this.min += b;
        this.ifClean = false;
    }

    public void setSecond(int b) {
        this.sec = b;
        this.ifClean = false;
    }

    public void addSecond(int b) {
        this.sec = this.sec += b;
        this.ifClean = false;
    }

    public void clean() {
        if (this.ifClean) {
            return;
        }
        Quote qsec = new Quote(this.sec, 60);
        this.sec = qsec.remainder();
        this.min += qsec.quotient();
        Quote qmin = new Quote(this.min, 60);
        this.min = qmin.remainder();
        this.hour += qmin.quotient();
        Quote qhour = new Quote(this.hour, 24);
        this.hour = qhour.remainder();
        this.day += qhour.quotient();
        this.ifClean = true;
    }

    public String toString() {
        return this.toStringSecond();
    }

    private static String toStrings(int[] vs, char[] cs) {
        int i;
        boolean[] boos = new boolean[vs.length];
        for (i = 0; i < boos.length; ++i) {
            boos[i] = true;
        }
        for (i = 0; i < boos.length - 1 && vs[i] == 0; ++i) {
            boos[i] = false;
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < vs.length; ++i2) {
            if (!boos[i2]) continue;
            sb.append(vs[i2] + Character.toString(cs[i2]));
        }
        return sb.toString();
    }

    public String toStringMinute() {
        if (!this.ifClean) {
            this.clean();
        }
        return Time.toStrings(new int[]{this.day, this.hour, this.min}, new char[]{DAY, HOUR, MIN});
    }

    public String toStringHour() {
        if (!this.ifClean) {
            this.clean();
        }
        return Time.toStrings(new int[]{this.day, this.hour}, new char[]{DAY, HOUR});
    }

    public String toStringSecond() {
        if (!this.ifClean) {
            this.clean();
        }
        return Time.toStrings(new int[]{this.day, this.hour, this.min, this.sec}, new char[]{DAY, HOUR, MIN, SEC});
    }

    public static void main(String[] args) throws Exception {
        Time t = new Time();
        t.setSecond(90);
        System.out.println(t.toString());
    }

    class Quote {
        private int quot;
        private int remainder;

        public Quote(int val, int div) {
            this.quot = Math.floorDiv(val, div);
            this.remainder = val - this.quot * div;
        }

        public int quotient() {
            return this.quot;
        }

        public int remainder() {
            return this.remainder;
        }
    }
}

