/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.misc;

import fork.lib.bio.misc.PhosphoSiteProteinPhos;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;

public class PhosphoSitePlusReader {
    public static final String MOUSE = "mouse";
    public static final String HUMAN = "human";
    public static final String RAT = "rat";
    public static int skip = 4;
    protected File file;
    protected HashMap<String, HashMap<String, PhosphoSiteProteinPhos>> org;

    public PhosphoSitePlusReader(File file) throws IOException {
        this.file = file;
        this.init();
    }

    private void init() throws IOException {
        String l;
        this.org = new HashMap();
        BufferedReader br = new BufferedReader(new FileReader(this.file));
        for (int i = 0; i < skip; ++i) {
            br.readLine();
        }
        while ((l = br.readLine()) != null) {
            PhosphoSiteProteinPhos prot;
            HashMap<Object, Object> orgPhos;
            String[] ss = l.split("\t");
            String id = ss[1];
            String phos = ss[4];
            String or = ss[6];
            char ch = phos.charAt(0);
            int pos = Integer.parseInt(phos.substring(1));
            if (this.org.containsKey(or)) {
                orgPhos = this.org.get(or);
                if (orgPhos.containsKey(id)) {
                    ((PhosphoSiteProteinPhos)orgPhos.get(id)).addPhosResidue(pos, ch);
                    continue;
                }
                prot = new PhosphoSiteProteinPhos(pos, ch);
                orgPhos.put(id, prot);
                continue;
            }
            orgPhos = new HashMap();
            prot = new PhosphoSiteProteinPhos(pos, ch);
            prot.addPhosResidue(pos, ch);
            orgPhos.put(id, prot);
            this.org.put(or, orgPhos);
        }
        br.close();
    }

    public HashMap<String, PhosphoSiteProteinPhos> getPhosForOrganism(String or) {
        return this.org.get(or);
    }

    public PhosphoSiteProteinPhos getPhosForProtein(String or, String prot) {
        return this.org.get(or).get(prot);
    }

    public static void main(String[] args) throws Exception {
        File f = new File("/home/forksapien/Desktop/proj_2/data/anno/Phosphorylation_site_dataset");
        PhosphoSitePlusReader fr = new PhosphoSitePlusReader(f);
        PhosphoSiteProteinPhos sss = fr.getPhosForProtein(MOUSE, "Q64264");
        for (Integer i : sss.phos.keySet()) {
            System.out.println(i + "   " + sss.phos.get(i));
        }
    }
}

