/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.misc;

import fork.lib.base.file.io.txt.ReadTable;
import fork.lib.bio.seq.region.DirectionalGenomicRegion;
import fork.lib.bio.seq.region.builder.GenomicRegionsBuilder;
import java.io.File;

public class SGDGTFReader {
    public static String GENE_ID_TAG = "gene_id \"";
    public File file;
    public GenomicRegionsBuilder gb;

    public SGDGTFReader(File f) throws Exception {
        this.file = f;
        this.init();
    }

    private void init() throws Exception {
        this.gb = new GenomicRegionsBuilder();
        ReadTable rt = new ReadTable(this.file);
        String[][] arr = rt.getTableAsArray();
        for (int i = 0; i < arr.length; ++i) {
            String[] r = arr[i];
            String comp = r[2];
            if (!comp.equals("CDS")) continue;
            DirectionalGenomicRegion dr = new DirectionalGenomicRegion(r[0], r[6].charAt(0), Integer.parseInt(r[3]), Integer.parseInt(r[4]));
            dr.setAttribute(r[8]);
            this.gb.add(dr);
        }
        this.gb.sortAll();
    }

    public static String getID(String s) {
        int indg = s.indexOf(GENE_ID_TAG);
        int inde = s.indexOf("\"", indg + GENE_ID_TAG.length() + 1);
        return s.substring(indg + GENE_ID_TAG.length(), inde);
    }

    public static void main(String[] args) throws Exception {
    }
}

