/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.misc.go;

import java.util.ArrayList;
import java.util.HashSet;

public class GoEntry {
    public String id;
    public String name;
    public boolean is_obsolete = false;
    public ArrayList<String> isa;
    public HashSet<GoEntry> children;
    public HashSet<GoEntry> parents;
    public Object attr;

    public GoEntry(String id, String name) {
        this.id = id;
        this.name = name;
        this.init();
    }

    private void init() {
        this.children = new HashSet();
        this.parents = new HashSet();
        this.isa = new ArrayList();
    }

    public void addChild(GoEntry c) {
        this.children.add(c);
    }

    public void addParent(GoEntry c) {
        this.parents.add(c);
    }

    public HashSet<GoEntry> getAllChildren() {
        HashSet<GoEntry> ret = new HashSet<GoEntry>();
        GoEntry ent = this;
        this.childAdd(ret, ent);
        return ret;
    }

    protected void childAdd(HashSet<GoEntry> set, GoEntry ent) {
        if (ent.children.isEmpty()) {
            return;
        }
        for (GoEntry e : ent.children) {
            set.add(e);
            this.childAdd(set, e);
        }
    }

    public String toString() {
        return this.id + "   " + this.name;
    }
}

