/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.misc.go;

import fork.lib.base.file.io.txt.ChunkEntry;
import fork.lib.base.file.io.txt.ChunkReader;
import fork.lib.base.file.io.txt.DefaultChunkReaderParam;
import fork.lib.base.format.StringOp;
import fork.lib.bio.misc.go.GoEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class GoOboParser {
    public static final String ID = "id: ";
    public static final String NAME = "name: ";
    public static final String NAMESPACE = "namespace: ";
    public static final String IS_A = "is_a: ";
    public static final String IS_OBSOLETE = "is_obsolete: ";
    public static final String BOLOGICAL_PROCESS = "biological_process";
    public static final String MOLECULAR_FUNCTION = "molecular_function";
    public static final String CELLULAR_COMPONENT = "cellular_component";
    public boolean ifverb = true;
    public File file;
    protected HashMap<String, HashMap<String, GoEntry>> allent;
    protected HashMap<String, GoEntry> roots;

    public GoOboParser(File file) throws Exception {
        this.file = file;
        this.init();
        this.start();
    }

    private void init() {
        this.allent = new HashMap();
        this.roots = new HashMap();
    }

    protected void initialise() throws Exception {
        ChunkEntry en;
        DefaultChunkReaderParam par = new DefaultChunkReaderParam();
        par.marks.add(Character.valueOf('['));
        ChunkReader mr = new ChunkReader(this.file.getAbsolutePath(), false, par);
        while ((en = mr.nextEntry()) != null) {
            GoEntry goe = this.toEntry(en.getChunk());
            if (goe == null) continue;
            goe.isa = this.getIsa(en.getChunk());
            String ns = this.getNameSpace(en.getChunk());
            if (!this.allent.containsKey(ns)) {
                this.allent.put(ns, new HashMap());
            }
            this.allent.get(ns).put(goe.id, goe);
        }
    }

    private GoEntry toEntry(ArrayList<String> al) {
        String id = null;
        String n = null;
        for (int i = 0; i < al.size(); ++i) {
            String l = al.get(i);
            if (id == null && l.indexOf(ID) == 0) {
                id = StringOp.substringAfter(l, ID);
                continue;
            }
            if (n == null && l.indexOf(NAME) == 0) {
                n = StringOp.substringAfter(l, NAME);
                continue;
            }
            if (l.indexOf(IS_OBSOLETE) != 0) continue;
            return null;
        }
        return new GoEntry(id, n);
    }

    private String getNameSpace(ArrayList<String> al) {
        String ns = "";
        for (int i = 0; i < al.size(); ++i) {
            String l = al.get(i);
            if (l.indexOf(NAMESPACE) != 0) continue;
            ns = StringOp.substringAfter(l, NAMESPACE);
        }
        return ns;
    }

    private ArrayList<String> getIsa(ArrayList<String> al) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < al.size(); ++i) {
            String l = al.get(i);
            if (l.indexOf(IS_A) != 0) continue;
            String n = StringOp.substringBetween(l, IS_A, " !");
            ret.add(n);
        }
        return ret;
    }

    protected void constructHierarchy() {
        for (String ns : this.allent.keySet()) {
            HashMap<String, GoEntry> hns = this.allent.get(ns);
            for (String id : hns.keySet()) {
                GoEntry en = hns.get(id);
                ArrayList<String> isas = en.isa;
                for (int i = 0; i < isas.size(); ++i) {
                    String isa = isas.get(i);
                    GoEntry par = hns.get(isa);
                    if (par == null) continue;
                    par.addChild(en);
                    en.addParent(par);
                }
                en.isa = null;
            }
        }
    }

    protected void findRoots() {
        for (String ns : this.allent.keySet()) {
            HashMap<String, GoEntry> hns = this.allent.get(ns);
            Iterator<String> itt = hns.keySet().iterator();
            HashSet<GoEntry> rt = new HashSet<GoEntry>();
            HashSet<GoEntry> checked = new HashSet<GoEntry>();
            while (itt.hasNext()) {
                String id = itt.next();
                GoEntry en = hns.get(id);
                this.check(en, rt, checked);
            }
            GoEntry[] rtarr = new GoEntry[rt.size()];
            this.roots.put(ns, rt.toArray(rtarr)[0]);
        }
    }

    private void check(GoEntry en, HashSet<GoEntry> rt, HashSet<GoEntry> checked) {
        if (checked.contains(en)) {
            return;
        }
        HashSet<GoEntry> pars = en.parents;
        if (pars.isEmpty()) {
            rt.add(en);
            checked.add(en);
            return;
        }
        for (GoEntry par : pars) {
            this.check(par, rt, checked);
            checked.add(par);
        }
    }

    public void start() throws Exception {
        this.initialise();
        if (this.ifverb) {
            System.out.println("initialised");
        }
        this.constructHierarchy();
        if (this.ifverb) {
            System.out.println("hierarchy constructed");
        }
        this.findRoots();
        if (this.ifverb) {
            System.out.println("roots found");
        }
    }

    public HashMap<String, HashMap<String, GoEntry>> getAllEntries() {
        return this.allent;
    }

    public HashMap<String, GoEntry> getAllRoots() {
        return this.roots;
    }

    public HashMap<String, GoEntry> getEntriesForNamespace(String ns) {
        return this.allent.get(ns);
    }

    public GoEntry getRootForNamespace(String ns) {
        return this.roots.get(ns);
    }

    public HashSet<GoEntry> getLeafEntries(String kingdom) throws Exception {
        HashSet<GoEntry> ret = new HashSet<GoEntry>();
        HashMap<String, GoEntry> hh = this.getAllEntries().get(kingdom);
        for (String id : hh.keySet()) {
            GoEntry en = hh.get(id);
            if (!en.children.isEmpty()) continue;
            ret.add(en);
        }
        return ret;
    }

    public HashSet<GoEntry> getMolecularFunctionLeafEntries() throws Exception {
        return this.getLeafEntries(MOLECULAR_FUNCTION);
    }

    public static void main(String[] args) throws Exception {
        File ff = new File("E:\\muxingu\\mystudy\\msc\\proj_2\\data\\anno/gene_ontology.1_2.obo");
        GoOboParser gg = new GoOboParser(ff);
        HashMap<String, GoEntry> mp = gg.getAllRoots();
        for (String s : mp.keySet()) {
            GoEntry ent = mp.get(s);
            System.out.println(ent.name);
        }
    }
}

