/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.misc.go;

import fork.lib.base.file.io.txt.ReadTable;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MouseGoMap {
    protected File f;
    public int[] skip = new int[]{0};
    public int idCol = 1;
    public int goCol = 4;
    protected HashMap<String, HashSet<String>> hash;

    public MouseGoMap(File f) throws Exception {
        this.f = f;
        this.init();
    }

    private void init() throws Exception {
        this.hash = new HashMap();
        ReadTable rt = new ReadTable(this.f);
        rt.setSkipRows(this.skip);
        String[][] arr = rt.getTableAsArray();
        for (int i = 0; i < arr.length; ++i) {
            String[] r = arr[i];
            String id = r[this.idCol];
            String go = r[this.goCol];
            if (!this.hash.containsKey(id)) {
                this.hash.put(id, new HashSet());
            }
            this.hash.get(id).add(go);
        }
    }

    public HashMap<String, HashSet<String>> getMap() {
        return this.hash;
    }

    public HashSet<String> getGoFor(String id) {
        return this.hash.get(id);
    }

    public static void main(String[] args) throws Exception {
        File f = new File("E:\\muxingu\\mystudy\\msc\\proj_2\\data\\anno/gene_association.goa_mouse");
        MouseGoMap gg = new MouseGoMap(f);
        Iterator<String> it = gg.getGoFor("A0A4X8").iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }
}

