/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.misc.go;

import fork.lib.base.file.io.txt.ReadTable;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class SGDGoMap {
    protected File f;
    public static int idCol = 10;
    public static int goCol = 4;
    public HashMap<String, HashSet<String>> geneToGo = new HashMap();
    public HashMap<String, HashSet<String>> goToGene = new HashMap();

    public SGDGoMap(File f) throws Exception {
        this.f = f;
        this.init();
    }

    private void init() throws Exception {
        ReadTable rt = new ReadTable(this.f);
        rt.param().setSkipSyntax("!");
        String[][] arr = rt.getTableAsArray();
        for (int i = 0; i < arr.length; ++i) {
            String[] r = arr[i];
            String id = r[idCol].split("\\|")[0];
            String go = r[goCol];
            if (id.indexOf("Y") != 0) continue;
            if (!this.geneToGo.containsKey(id)) {
                this.geneToGo.put(id, new HashSet());
            }
            this.geneToGo.get(id).add(go);
            if (!this.goToGene.containsKey(go)) {
                this.goToGene.put(go, new HashSet());
            }
            this.goToGene.get(go).add(id);
        }
    }

    public HashSet<String> getGoFor(String id) {
        return this.geneToGo.get(id);
    }

    public HashSet<String> getGenesFor(String geneId) {
        return this.goToGene.get(geneId);
    }

    public static void main(String[] args) throws Exception {
        File f = new File("/home/forksapien/mystudy/phd/files/anno/raw/gene_association.sgd");
        SGDGoMap gg = new SGDGoMap(f);
        Iterator<String> it = gg.getGoFor("A0A4X8").iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
    }
}

