/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.misc.id;

import fork.lib.bio.misc.id.IDMapper;
import fork.lib.bio.misc.id.UnirotIDMapperParam;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

public class UniprotIDMapper
implements IDMapper {
    public static int dotNumPerLine = 60;
    public static final String UNIPROT_SERVER = "http://www.uniprot.org/";
    public static final String TOOL = "mapping";
    public static final int MAX_URL_LEN = 1600;
    protected UnirotIDMapperParam par;
    protected Collection<String> ids;
    protected HashMap<String, String> hashmap = new HashMap();
    protected int n = 0;

    public UniprotIDMapper(String[] ids, UnirotIDMapperParam par) throws Exception {
        this.ids = Arrays.asList(ids);
        this.par = par;
        this.init();
    }

    public UniprotIDMapper(Collection<String> ids, UnirotIDMapperParam par) throws Exception {
        this.ids = ids;
        this.par = par;
        this.init();
    }

    private void init() throws Exception {
        if (this.par == null) {
            this.par = new UnirotIDMapperParam();
        }
        int len = 0;
        ArrayList<String> buff = new ArrayList<String>();
        for (String id : this.ids) {
            if (len >= 1600) {
                this.connectAndDump(buff);
                len = 0;
                buff = new ArrayList();
            }
            buff.add(id);
            len += id.length();
        }
        if (!buff.isEmpty()) {
            this.connectAndDump(buff);
        }
    }

    public UnirotIDMapperParam param() {
        return this.par;
    }

    private void connectAndDump(ArrayList<String> buff) throws Exception {
        String location = this.getLocation(buff);
        URL url = new URL(location);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        HttpURLConnection.setFollowRedirects(true);
        conn.setDoInput(true);
        conn.connect();
        int status = conn.getResponseCode();
        while (true) {
            int wait = 0;
            String header = conn.getHeaderField("Retry-After");
            if (header != null) {
                wait = Integer.valueOf(header);
            }
            if (wait == 0) break;
            conn.disconnect();
            Thread.sleep(wait * 1000);
            conn = (HttpURLConnection)new URL(location).openConnection();
            conn.setDoInput(true);
            conn.connect();
            status = conn.getResponseCode();
        }
        if (status == 200) {
            InputStream reader = conn.getInputStream();
            URLConnection.guessContentTypeFromStream(reader);
            StringBuilder builder = new StringBuilder();
            int a = 0;
            while ((a = reader.read()) != -1) {
                builder.append((char)a);
            }
            this.toHashMap(builder.toString());
            buff.clear();
            ++this.n;
            System.err.print(".");
            if (this.n > dotNumPerLine) {
                this.n = 0;
                System.err.println();
            }
        } else {
            conn.disconnect();
        }
    }

    protected String getLocation(ArrayList<String> buff) throws UnsupportedEncodingException {
        UnirotIDMapperParam.ParameterNameValue[] params = this.getParamsNameValue(buff);
        StringBuilder sb = new StringBuilder("http://www.uniprot.org/mapping/?");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append('&');
            }
            sb.append(params[i].name).append('=').append(params[i].value);
        }
        return sb.toString();
    }

    protected UnirotIDMapperParam.ParameterNameValue[] getParamsNameValue(ArrayList<String> alid) throws UnsupportedEncodingException {
        ArrayList<UnirotIDMapperParam.ParameterNameValue> al = this.par.getParameters();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < alid.size(); ++i) {
            if (i > 0) {
                sb.append("\t");
            }
            sb.append(alid.get(i));
        }
        UnirotIDMapperParam.ParameterNameValue pnv = new UnirotIDMapperParam.ParameterNameValue("query", sb.toString());
        al.add(pnv);
        UnirotIDMapperParam.ParameterNameValue[] ret = new UnirotIDMapperParam.ParameterNameValue[al.size()];
        al.toArray(ret);
        return ret;
    }

    protected void toHashMap(String s) {
        String[] ls = s.split("\n");
        for (int i = 0; i < ls.length; ++i) {
            String l = ls[i];
            String[] lss = l.split("\t");
            if (lss.length <= 0 || lss[0].equalsIgnoreCase("From")) continue;
            for (int j = 0; j < lss.length; ++j) {
                this.hashmap.put(lss[0], lss[1]);
            }
        }
    }

    @Override
    public String map(String id) {
        return this.hashmap.get(id);
    }

    public HashMap<String, String> getMap() {
        return this.hashmap;
    }

    public static void main(String[] args) throws Exception {
        String[] ids = new String[]{"P13368", "P20806", "Q9UM73", "P97793", "Q17192", "FFFF"};
        UnirotIDMapperParam par = new UnirotIDMapperParam("ACC", "P_REFSEQ_AC");
        UniprotIDMapper map = new UniprotIDMapper(ids, par);
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            System.out.println(id + "   " + map.map(id));
        }
    }
}

