/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.misc.id;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;

public class UnirotIDMapperParam {
    public static final String UNIPROTKB_AC_ID = "ACC+ID";
    public static final String UNIPROTKB_AC = "ACC";
    public static final String UNIPROTKB_ID = "ID";
    public static final String REFSEQ_PROTEIN = "P_REFSEQ_AC";
    public static final String PDB = "PDB_ID";
    public static final String ENSEMBL = "ENSEMBL_ID";
    public static final String ENSEMBL_PROTEIN = "ENSEMBL_PRO_ID";
    public static final String ENSEMBL_GENOMES = "ENSEMBLGENOME_ID";
    public static final String UCSC = "UCSC_ID";
    public static final String MGI = "MGI_ID";
    public static final String SGD = "SGD_ID";
    public final String from;
    public final String to;

    public UnirotIDMapperParam(String from, String to) {
        this.from = from;
        this.to = to;
    }

    public UnirotIDMapperParam() {
        this.from = UNIPROTKB_AC;
        this.to = UNIPROTKB_ID;
    }

    public ArrayList<ParameterNameValue> getParameters() throws UnsupportedEncodingException {
        ArrayList<ParameterNameValue> ret = new ArrayList<ParameterNameValue>();
        ret.add(new ParameterNameValue("from", this.from));
        ret.add(new ParameterNameValue("to", this.to));
        ret.add(new ParameterNameValue("format", "tab"));
        return ret;
    }

    protected static class ParameterNameValue {
        public final String name;
        public final String value;

        public ParameterNameValue(String name, String value) throws UnsupportedEncodingException {
            this.name = URLEncoder.encode(name, "UTF-8");
            this.value = URLEncoder.encode(value, "UTF-8");
        }
    }
}

