/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.misc.microarray;

import fork.lib.bio.misc.id.IDMapperMultiple;
import fork.lib.bio.misc.microarray.ArrayValueSelector;
import fork.lib.bio.misc.microarray.ValueSelectorMax;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ArrayProbeMapping {
    protected IDMapperMultiple idmap;
    protected HashMap<String, Double> probeVal;
    protected ArrayValueSelector sel = new ValueSelectorMax();
    protected HashMap<String, ArrayList<Double>> idVal = new HashMap();

    public ArrayProbeMapping(IDMapperMultiple idmap, HashMap<String, Double> probeVal) throws Exception {
        this.idmap = idmap;
        this.probeVal = probeVal;
        this.init();
    }

    protected void init() throws Exception {
        for (String pr : this.probeVal.keySet()) {
            Double v = this.probeVal.get(pr);
            ArrayList<String> ids = this.idmap.map(pr);
            if (ids == null) continue;
            for (int i = 0; i < ids.size(); ++i) {
                ArrayList<Object> al;
                String id = ids.get(i);
                if (!this.idVal.containsKey(id)) {
                    al = new ArrayList<Double>();
                    al.add(v);
                    this.idVal.put(id, al);
                    continue;
                }
                al = this.idVal.get(id);
                al.add(v);
                this.idVal.put(id, al);
            }
        }
    }

    public void setValueSelector(ArrayValueSelector sel) {
        this.sel = sel;
    }

    public void writeToFile(File out) throws Exception {
        out.getAbsoluteFile().getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(out));
        Object[] ids = new String[this.idVal.keySet().size()];
        this.idVal.keySet().toArray(ids);
        Arrays.sort(ids);
        for (int i = 0; i < ids.length; ++i) {
            Object id = ids[i];
            ArrayList<Double> vs = this.idVal.get(id);
            double v = this.sel.selectValue(vs);
            if (!this.ifWriteID((String)id)) continue;
            bw.write((String)id + "\t" + v + "\n");
        }
        bw.close();
    }

    protected boolean ifWriteID(String id) throws Exception {
        return true;
    }

    public static void main(String[] args) throws Exception {
    }
}

