/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.misc.rnafold;

import fork.lib.bio.misc.rnafold.RNAFoldEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class RNAFoldReader {
    public static final String IND = ">";
    protected BufferedReader br;
    protected String buffLine = "";

    public RNAFoldReader(String path) {
        try {
            this.br = new BufferedReader(new FileReader(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public RNAFoldReader(File file) {
        this(file.getAbsolutePath());
    }

    public RNAFoldEntry nextEntry() throws IOException {
        this.buffLine = this.br.readLine();
        if (this.buffLine == null) {
            return null;
        }
        String l1 = this.br.readLine();
        String l2 = this.br.readLine();
        RNAFoldEntry ent = this.newEntry(this.buffLine, l1, l2);
        return ent;
    }

    protected RNAFoldEntry newEntry(String tl, String l1, String l2) {
        String tit = RNAFoldReader.getTitle(tl);
        int sind = l2.indexOf(" ");
        String str = l2.substring(0, sind);
        String es = l2.substring(sind + 1);
        es = es.replaceAll("\\(", "");
        es = es.replaceAll("\\)", "");
        double e = Double.parseDouble(es);
        return new RNAFoldEntry(tit, l1, str, e);
    }

    public static String getTitle(String l) {
        return l.substring(l.indexOf(IND) + IND.length());
    }

    public void close() throws IOException {
        this.br.close();
    }

    public static void main(String[] args) throws Exception {
        RNAFoldEntry en;
        File f = new File("F:/programs/java/app/ProteinCharge/out2/scoring/filt/ss/ss_srsf3.txt");
        RNAFoldReader rf = new RNAFoldReader(f);
        while ((en = rf.nextEntry()) != null) {
            System.out.println(en.getUnpairedBases() + "   " + en.getStructure().length() + "  " + en.getSequence().length());
        }
    }
}

