/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.misc.stringdb;

import fork.lib.base.Print;
import fork.lib.bio.misc.stringdb.StringDBParam;
import fork.lib.bio.misc.stringdb.StringDBResultSet;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class StringDB {
    public static int buffLen = 8;
    protected ArrayList<String> ids;
    protected StringDBParam par;
    protected StringDBResultSet res = new StringDBResultSet();

    public StringDB(ArrayList<String> ids, StringDBParam par) throws Exception {
        this.ids = ids;
        this.par = par;
        this.init();
    }

    public StringDBParam param() {
        return this.par;
    }

    protected void init() throws Exception {
        if (this.par == null) {
            this.par = new StringDBParam(StringDBParam.SPECIES_HUMAN);
        }
        int ind = 0;
        while (ind < this.ids.size()) {
            int indh = ind + buffLen < this.ids.size() ? ind + buffLen : this.ids.size();
            ArrayList<String> idt = new ArrayList<String>();
            for (int i = ind; i < indh; ++i) {
                idt.add(this.ids.get(i));
            }
            this.appendToResult(idt);
            ind = indh;
        }
    }

    protected void appendToResult(ArrayList<String> idt) throws Exception {
        String l;
        URL url = new URL(this.par.toURL(idt));
        URLConnection con = url.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
        String rem = this.par.species + ".";
        while ((l = br.readLine()) != null) {
            String id = l.replace(rem, "");
            this.res.add(id);
        }
        br.close();
    }

    public StringDBResultSet getRsultSets() {
        return this.res;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("YML115C");
        ids.add("YOL012C");
        ids.add("YJL115W");
        ids.add("YBL002W");
        ids.add("YER030W");
        ids.add("YNL030W");
        ids.add("YPL050C");
        ids.add("YDR224C");
        ids.add("YBR009C");
        ids.add("YNL031C");
        ids.add("YGL241W");
        ids.add("YNL107W");
        StringDBParam par = new StringDBParam(StringDBParam.SPECIES_CEREVISIAE);
        StringDB ss = new StringDB(ids, par);
        Print.collection(ss.getRsultSets().getIDs());
    }
}

