/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.misc.stringdb;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

public class StringDBParam {
    public static String PROTOCOL = "http://";
    public static String DATABASE = "string-db.org";
    public static String ACCESS = "api";
    public static String FORMAT = "tsv-no-header";
    public static String REQUEST = "interactorsList";
    public static String IDENTIFIERS = "identifiers";
    public static String SPECIES_HUMAN = "9606";
    public static String SPECIES_CEREVISIAE = "4932";
    protected String species;
    protected String param;

    public StringDBParam(String species, String param) {
        this.species = species;
        this.param = param;
    }

    public StringDBParam(String species) {
        this(species, "");
    }

    public String toURL(ArrayList<String> ids) {
        String ret = PROTOCOL + DATABASE + "/" + ACCESS + "/" + FORMAT + "/" + REQUEST + "?";
        ret = ret + IDENTIFIERS + "=";
        for (int i = 0; i < ids.size(); ++i) {
            ret = ret + this.species + "." + ids.get(i);
            if (i >= ids.size() - 1) continue;
            ret = ret + "%0D";
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        String inputLine;
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("YML115C");
        ids.add("YOL012C");
        ids.add("YJL115W");
        ids.add("YBL002W");
        ids.add("YER030W");
        ids.add("YNL030W");
        ids.add("YPL050C");
        ids.add("YDR224C");
        ids.add("YBR009C");
        ids.add("YNL031C");
        ids.add("YGL241W");
        ids.add("YNL107W");
        StringDBParam ss = new StringDBParam("4932", "");
        System.out.println(ss.toURL(ids));
        URL oracle = new URL(ss.toURL(ids));
        URLConnection yc = oracle.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
        while ((inputLine = in.readLine()) != null) {
            System.out.println(inputLine);
        }
        in.close();
    }
}

