/*
 * Decompiled with CFR 0.152.
 */
package fork.lib.bio.seq;

import fork.lib.bio.seq.AminoAcidParser;

public class AminoAcid
implements Cloneable {
    protected int hash;

    public AminoAcid(char c) {
        this.hash = AminoAcidParser.getHashCodeForChar(c);
    }

    public boolean isLysine() {
        return this.hash == 1100;
    }

    public boolean isArginine() {
        return this.hash == 1800;
    }

    public boolean isPositivelyCharged() {
        return this.hash == 1100 || this.hash == 1800 || this.hash == 800;
    }

    public boolean isLysineOrArginine() {
        return this.hash == 1100 || this.hash == 1800;
    }

    public boolean isNegativelyCharged() {
        return this.hash == 400 || this.hash == 500;
    }

    public char getOneLetterCode() {
        try {
            return AminoAcidParser.getOneLeterCodeFor(this.hash);
        }
        catch (Exception e) {
            return ' ';
        }
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AminoAcid other = (AminoAcid)obj;
        return this.hash == other.hash;
    }

    public String toString() {
        return Character.toString(this.getOneLetterCode());
    }

    public AminoAcid clone() {
        try {
            return (AminoAcid)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        AminoAcid a = new AminoAcid('b');
    }
}

